﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
//using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Collections;
using System.Globalization;

namespace WindowsFormsApplication1
{
    public partial class ViewRuns : Form
    {
        //------------------------------
        //Latest Run's Tool Parameters
        //------------------------------
        public class LatestToolParams
        {
            public int NoArms;
            public int ToolSize;
            public Int64 LastRecCt;
            public Int64 LastSampleCt;
            public Int64 RunBeginSector;
            public int IsCtRunTimeBased;
            public Int64 LastPriIndex;
            public Int64 Frequency;
            public Int64 LastSecIndex;
            public double Threshold;
            public int[] ArmOfChnl;
            public double[] CalibSlope;
            public double[] YIntcpt;
            public bool DataValid;
        }
        public LatestToolParams[] ToolParamsInst;

        public class CtRunTableVals
        {
            public string Distance;
            public string Time;
            public string OClock;
            public string XSctn;
            public string Length;
        }
        public CtRunTableVals[] CtRunTableValsInst;

        //------------------------------
        //Global Variables across Class
        //------------------------------
        int LatestRunNum;
        public int CtRunNum;
        public string CtRunNumPath;
        bool[] Runvalid;

        //-------------------------------
        //Ct Run's Variables
        //-------------------------------
        bool IsRunActiveDownload;
        int CtTableSelectedIndex;

        //-------------------------------
        //Table Data Variables
        //-------------------------------
        public double[, ,] SkeletonData;
        public int[] RecCtinRun;
        string[] LaunchDate, DownloadDate;

        //-------------------------------
        //Download Variables
        //-------------------------------
        DownloadAndPrcs DwnldPrcsInst;
        int CtDownloadRecNum;
        int DownloadRet;
        int RecsLeftToDownload;
        int NewDataAvl, NewDataRow;

        public ViewRuns()
        {
            InitializeComponent();
        }

        private void ViewRuns_Load(object sender, EventArgs e)
        {
            ShowInitGUI();
            InitLoadBGWrkr.RunWorkerAsync();


        }



        private void InitLoadBGWrkr_DoWork(object sender, DoWorkEventArgs e)
        {
            int i, j, k;
          
            //Find Latest Run Number
            Program.MainInst.ReadConfigFile();
            LatestRunNum = Program.MainInst.CtRunNum;
            
            //Allocate RunValid, ToolLatestParamsInst, SkeletonData, LaunchDate, DownloadDate
            Runvalid = new bool[LatestRunNum + 1];
            ToolParamsInst = new LatestToolParams[LatestRunNum + 1];
            for (i = 0; i <= Program.MainInst.CtRunNum; i++) ToolParamsInst[i] = new LatestToolParams();
            RecCtinRun = new int[LatestRunNum + 1];
            SkeletonData = new double[(LatestRunNum+1), 1000, (9+24)];
            LaunchDate = new string[(LatestRunNum + 1)];
            DownloadDate = new string[LatestRunNum + 1];

            for (i = Program.MainInst.CtRunNum; i >= 0; i--)
            {
                CtRunNumPath = Program.MainInst.RootDrive + Program.MainInst.JobNo + i.ToString("00");
                if (VerifyAndLoadTS(CtRunNumPath, i) == true)
                {
                    //If Current Iteration is the latest RunNum, read and load the calib file
                    bool CalibFileValid = true;
                    Runvalid[i] = true;
                    try
                    {
                            //Load the Ct Run's calib file on TextReader
                            TextReader CalibFileRdr = File.OpenText(CtRunNumPath + "\\calib.bin");

                            //Read Line after Line, Parse and Load it on the appropriate Variables
                            string[] ReturnElements;
                            
                            //Read no Arms
                            ReturnElements = CalibFileRdr.ReadLine().Split(new char[] { ':' });
                            ToolParamsInst[i].NoArms = Convert.ToInt32(ReturnElements[1]);
                            ReturnElements = null;
                            //Read Tool Size
                            ReturnElements = CalibFileRdr.ReadLine().Split(new char[] { ':' });
                            ToolParamsInst[i].ToolSize = Convert.ToInt32(ReturnElements[1]);
                            ReturnElements = null;
                            //Read Last Rec Ct
                            ReturnElements = CalibFileRdr.ReadLine().Split(new char[] { ':' });
                            ToolParamsInst[i].LastRecCt = Convert.ToInt32(ReturnElements[1]);
                            ReturnElements = null;
                            //Read Last Sample Ct
                            ReturnElements = CalibFileRdr.ReadLine().Split(new char[] { ':' });
                            ToolParamsInst[i].LastSampleCt = Convert.ToInt64(ReturnElements[1]);
                            ReturnElements = null;
                            //Run Begin Sector    
                            ReturnElements = CalibFileRdr.ReadLine().Split(new char[] { ':' });
                            ToolParamsInst[i].RunBeginSector = Convert.ToInt64(ReturnElements[1]);
                            ReturnElements = null;
                            //Read If Time Based
                            ReturnElements = CalibFileRdr.ReadLine().Split(new char[] { ':' });
                            ToolParamsInst[i].IsCtRunTimeBased = (Convert.ToInt32(ReturnElements[1]));
                            ReturnElements = null;
                            //Read LastPriIndex
                            ReturnElements = CalibFileRdr.ReadLine().Split(new char[] { ':' });
                            ToolParamsInst[i].LastPriIndex = Convert.ToInt64(ReturnElements[1]);
                            ReturnElements = null;
                            //Read Frequency
                            ReturnElements = CalibFileRdr.ReadLine().Split(new char[] { ':' });
                            ToolParamsInst[i].Frequency = Convert.ToInt32(ReturnElements[1]);
                            ReturnElements = null;
                            //Read LastSecIndex
                            ReturnElements = CalibFileRdr.ReadLine().Split(new char[] { ':' });
                            ToolParamsInst[i].LastSecIndex = Convert.ToInt32(ReturnElements[1]);
                            ReturnElements = null;
                            //Read Threshold
                            ReturnElements = CalibFileRdr.ReadLine().Split(new char[] { ':' });
                            ToolParamsInst[i].Threshold = Convert.ToInt32(ReturnElements[1]);
                            ReturnElements = null;

                            if (i == LatestRunNum)
                            {
                                //Read ArmofChnl Values
                                ToolParamsInst[i].ArmOfChnl = new int[ToolParamsInst[i].NoArms];

                                for (j = 0; j < ToolParamsInst[i].NoArms; j++)
                                {
                                    ReturnElements = CalibFileRdr.ReadLine().Split(new char[] { ':' });
                                    ToolParamsInst[i].ArmOfChnl[j] = Convert.ToInt32(ReturnElements[1]);
                                    ReturnElements = null;
                                }

                                //Read SlopeofArm Values
                                ToolParamsInst[i].CalibSlope = new double[ToolParamsInst[i].NoArms];

                                for (j = 0; j < ToolParamsInst[i].NoArms; j++)
                                {
                                    ReturnElements = CalibFileRdr.ReadLine().Split(new char[] { ':' });
                                    ToolParamsInst[i].CalibSlope[j] = Convert.ToDouble(ReturnElements[1]);
                                    ReturnElements = null;
                                }

                                //Read YIntcptofArm Values
                                ToolParamsInst[i].YIntcpt = new double[ToolParamsInst[i].NoArms];

                                for (j = 0; j < ToolParamsInst[i].NoArms; j++)
                                {
                                    ReturnElements = CalibFileRdr.ReadLine().Split(new char[] { ':' });
                                    ToolParamsInst[i].YIntcpt[j] = Convert.ToDouble(ReturnElements[1]);
                                    ReturnElements = null;
                                }
                                CalibFileRdr.Close();
                                ToolParamsInst[i].DataValid = true;
                            }
                        }
                    catch
                    {
                        CalibFileValid = false;
                        ToolParamsInst[i].DataValid = false;
                    }

                    
                    //------------------------------------
                    //If calibFile is successfully processed or Run not the latest run
                    //proceed with trying to read skeleton.bin for each of the job
                    //-------------------------------------
                    if (CalibFileValid == true)
                    {
                        try
                        {
                            //Load the Ct Run's calib file on TextReader
                            TextReader SkeletonFileRdr = File.OpenText(CtRunNumPath + "\\skeleton.bin");

                            //Read Line after Line, Parse and Load it on the appropriate Variables
                            string[] ReturnElements;
                            //Perform a dummy read on the first line
                            SkeletonFileRdr.ReadLine();
                            j = 0;
                            
                            while (SkeletonFileRdr.Peek() != -1)
                            {
                                ReturnElements = SkeletonFileRdr.ReadLine().Split(new char[] { ',' });

                                for (k = 0; k < 33; k++)
                                {
                                    SkeletonData[i, j, k] =  Convert.ToDouble(ReturnElements[k]);
                                }
                                j++;
                            }
                            RecCtinRun[i] = j;
                            SkeletonFileRdr.Close();
                        }
                        catch
                        {
                            Runvalid[i] = false;
                        }
                    }

                    
                }
                else Runvalid[i] = false;
            }

        }

        private void InitLoadBGWrkr_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            int i;
            bool AnyRunValid = false;
            //Update GUI elements
            for (i = LatestRunNum; i >= 0; i--)
            {
                if (Runvalid[i] == true)
                {
                    CtRunNum = i;
                    AnyRunValid = true;
                    LoadCtRunOnTable();
                    i = -1;
                    if (IsRunActiveDownload == true)
                    {
                        DwnldPrcsBGWrkr.RunWorkerAsync();
                    }
                    HideInitGUI();
                }
            }

            if (AnyRunValid == false)
            {
                OnTableLbl.Text = "No Runs to Display";
                CreateReportBtn.Visible = false;
                ExitTmr.Enabled = true;
                InitLbl.Text = "";
            }

        }

        //-------------------------------------
        //Load Ct Run on Table
        //-------------------------------------
        private void LoadCtRunOnTable() //Control variables are global
        {
            //Find Out if CtRun is an active download
            FindIsRunActiveDownload();

            //Clear Table
            columnModel1.Columns.Clear();
            tableModel1.Rows.Clear();

            //Create Columns
            CreateColumnTables();

            //Create Rows
            CreateAndLoadRows();

            //Populate Run Specific Fields - Labels
            PopulateRunLabels();

            //Button Resolution
            FindButtonResolution();

            //Choose Unit Format
            if (Program.MainInst.IsImperialPref > 0) ImperialRadio.Checked = true;
            else MetricRadio.Checked = true;

            //If Run Anactivedownload, Enable Timer
            if (IsRunActiveDownload == true) EventTmr.Enabled = true;

            ClearXSctn();

            if (RecCtinRun[CtRunNum] > 0)
            {
                DrawXSctn(0);
                OnTableLbl.Text = "";

            }
            else
            {
                OnTableLbl.Text = "No Records";

            }
        }

        //-------------------------------------
        //Btn Resolution Module
        //-------------------------------------
        void FindButtonResolution()
        {
            int i;
            PrevRunBtn.Enabled = false;
            //If PrevBtn should be displayed??
            for (i = (CtRunNum - 1); i >= 0; i--)
            {
                if (Runvalid[i] == true)
                {
                    i = -1;
                    PrevRunBtn.Enabled = true;
                }
            }

            NextRunBtn.Enabled = false;
            //If Next Button shold be displayed
            for (i = (CtRunNum + 1); i <= LatestRunNum; i++)
            {
                if (Runvalid[i] == true)
                {
                    i = LatestRunNum + 2;
                    NextRunBtn.Enabled = true;
                }
            }

        }

        //--------------------------------------
        //Populate Run Specific Fields
        //--------------------------------------
        void PopulateRunLabels()
        {
            int StorageCtRunNum;
            StorageCtRunNum = CtRunNum;
            RunNumLbl.Text = "Job Number: " + Program.MainInst.JobNo + StorageCtRunNum.ToString("00");

            if (ToolParamsInst[CtRunNum].IsCtRunTimeBased == 1)
            {
                RunTypeLbl.Text = "Run Type: Frequency " + ToolParamsInst[CtRunNum].Frequency.ToString() + " Samples per second";
            }
            else RunTypeLbl.Text = "Run Type: Distance Based";

            double DistanceDbl;
            //Distance Calculation
            if (ToolParamsInst[CtRunNum].IsCtRunTimeBased == 1) DistanceDbl = ((double) ToolParamsInst[CtRunNum].LastSecIndex) / (double) 48;
            else DistanceDbl = ( (double) ToolParamsInst[CtRunNum].LastSampleCt) / (double) 48;
            if (ToolParamsInst[CtRunNum].ToolSize >= 16) DistanceDbl *= 2;

            if (ImperialRadio.Checked == true) DistanceLbl.Text = "Distance: " + DistanceDbl.ToString("0.00") + " Feet  (" + (DistanceDbl / 5280).ToString("0.00") + " mi)";
            else DistanceLbl.Text = "Distance: " + (DistanceDbl * 0.3048).ToString("0.00") + " meters  (" + ( (DistanceDbl * 0.3048) / 1000).ToString("0.00") + " km)";
            
            //ToolSize
            if (ImperialRadio.Checked == true) ToolSizeLbl.Text = "Tool Size: " + ToolParamsInst[CtRunNum].ToolSize.ToString("0") + " inch";
            else ToolSizeLbl.Text = "Tool Size: " + (ToolParamsInst[CtRunNum].ToolSize * 25.4).ToString("0") + " mm";

            
            DateTime LaunchDateTime, DownloadDateTime;

            DateTime.TryParseExact(LaunchDate[CtRunNum], "MM/dd/yyyy HH:mm:ss.fff", null, DateTimeStyles.None, out LaunchDateTime);
            DateTime.TryParseExact(DownloadDate[CtRunNum], "MM/dd/yyyy HH:mm:ss.fff", null, DateTimeStyles.None, out DownloadDateTime);

            LaunchDateLbl.Text = "Tool ON Time:" + LaunchDateTime.ToString("MMM d yyyy HH:mm:ss");
            DownloadDateLbl.Text = "Download Time:" + DownloadDateTime.ToString("MMM d yyyy HH:mm:ss");
        }

        //--------------------------------------
        //Create and Load Rows
        //--------------------------------------
        void CreateAndLoadRows()
        {
            int i, j;
            //Loop through Number of Records in the CtRunNum
            if (CtRunTableValsInst != null) CtRunTableValsInst = null;

            CtRunTableValsInst = new CtRunTableVals[RecCtinRun[CtRunNum]];
            for (i = 0; i < RecCtinRun[CtRunNum]; i++) CtRunTableValsInst[i] = new CtRunTableVals();

            //Convert them to string with appropriate modification and formatting
            for (i = 0; i < RecCtinRun[CtRunNum]; i++)
            {
                //Create Row
                tableModel1.Rows.Add(new XPTable.Models.Row());

                //Create Cells
                for (j = 0; j < 6; j++) tableModel1.Rows[i].Cells.Add(new XPTable.Models.Cell());
                if (IsRunActiveDownload == true) tableModel1.Rows[i].Cells.Add(new XPTable.Models.Cell());

                //Populate Values in Row
                LoadATableRow(i);
            }
        }

        //--------------------------------------
        //Load a row as specified
        //--------------------------------------
        void LoadATableRow(int RowNum)
        {
            object Val = new object();
            Val = RowNum + 1;
            //First Column is S.No.
            tableModel1.Rows[RowNum].Cells[0].Data =Val;
            
            //Second Column is Time
            string[] TempStrArray1;
            string[] TempStrArray2;
            string[] TempStrArray3;
            TempStrArray1 = LaunchDate[CtRunNum].Split(new char[] { ' ' });
            TempStrArray2 = TempStrArray1[0].Split(new char[] { '/' });
            TempStrArray3 = TempStrArray1[1].Split(new char[] { ':' });
            TempStrArray1 = null;
            TempStrArray1 = TempStrArray3[2].Split(new char[] { '.' });
            DateTime TempTime = new DateTime(Convert.ToInt32(TempStrArray2[2]), Convert.ToInt32(TempStrArray2[0]), Convert.ToInt32(TempStrArray2[1]),
                Convert.ToInt32(TempStrArray3[0]), Convert.ToInt32(TempStrArray3[1]), Convert.ToInt32(TempStrArray1[0]), Convert.ToInt32(TempStrArray1[1]));
            double TmpDbl;
            if (SkeletonData[CtRunNum, RowNum, 8] != 1)
            {
                if (ToolParamsInst[CtRunNum].IsCtRunTimeBased == 1)
                {
                    TmpDbl = ( ToolParamsInst[CtRunNum].Frequency);
                    TmpDbl = (1 / TmpDbl) * 1000;
                    TmpDbl *= (SkeletonData[CtRunNum, RowNum, 0]);
                    TempTime = TempTime.AddMilliseconds(TmpDbl);
                }
                else
                {
                    TmpDbl = (Convert.ToUInt32(SkeletonData[CtRunNum, RowNum, 2]) );
                    TempTime = TempTime.AddMilliseconds(TmpDbl);
                }
            }
            else
            {
                TempTime = TempTime.AddMilliseconds(Convert.ToUInt32(SkeletonData[CtRunNum, RowNum, 3]));
            }
            tableModel1.Rows[RowNum].Cells[1].Text = TempTime.ToString("MMM d yyyy HH:mm:ss");
            CtRunTableValsInst[RowNum].Time = TempTime.ToString("MMM d yyyy HH:mm:ss");

            Val = null;
            //Third Column is Distance
            if (SkeletonData[CtRunNum, RowNum, 8] != 1)
            {
                if (ToolParamsInst[CtRunNum].IsCtRunTimeBased == 1) TmpDbl = Convert.ToDouble(SkeletonData[CtRunNum, RowNum, 2]); //Distance in Sec Param
                else TmpDbl = Convert.ToDouble(SkeletonData[CtRunNum, RowNum, 0]); //Distance in Primary field
                
                TmpDbl /= 48;
                if ((ToolParamsInst[CtRunNum].ToolSize >= 16) && (ToolParamsInst[CtRunNum].ToolSize <= 22)) TmpDbl *= 2;

                if (MetricRadio.Checked == true) TmpDbl *= 0.3048;
                Val = Math.Round(TmpDbl, 2);
            }
            else
            {
                if (ImperialRadio.Checked == true) Val = Math.Round( SkeletonData[CtRunNum, RowNum, 4], 2);
                else
                {
                    TmpDbl = Convert.ToDouble(SkeletonData[CtRunNum, RowNum, 4]);
                    TmpDbl *= 0.3048;
                    Val = Math.Round(TmpDbl, 2);
                }
            }
            tableModel1.Rows[RowNum].Cells[2].Data = Val;
            CtRunTableValsInst[RowNum].Distance = Val.ToString();

            Val = null;
            //Fourth Column is MinID
            if (SkeletonData[CtRunNum, RowNum, 8] == 1)
            {
                if (ImperialRadio.Checked == true) Val = Math.Round( SkeletonData[CtRunNum, RowNum, 5], 2);
                else
                {
                    TmpDbl = Convert.ToDouble(SkeletonData[CtRunNum, RowNum, 5]);
                    TmpDbl *= 25.4;
                    Val = Math.Round(TmpDbl, 2);
                }
            }
            tableModel1.Rows[RowNum].Cells[3].Data = Val;
            if (Val != null) CtRunTableValsInst[RowNum].XSctn = Val.ToString();
            else CtRunTableValsInst[RowNum].XSctn = "";

            //Fifth Column is O'Clock
            Val = null;
            CtRunTableValsInst[RowNum].OClock = "";
            //Fourth Column is MinID
            if (SkeletonData[CtRunNum, RowNum, 8] == 1)
            {
                long OClkMins;
                TmpDbl = SkeletonData[CtRunNum, RowNum, 6];
                TmpDbl *= 2;
                string TmpOClockstr = Math.DivRem((long)TmpDbl, 60, out OClkMins).ToString("00");
                TmpOClockstr += ":" + OClkMins.ToString("00");
                tableModel1.Rows[RowNum].Cells[4].Text = TmpOClockstr;
                CtRunTableValsInst[RowNum].OClock = TmpOClockstr;
            }
            

            Val = null;
            //Sixth Colum is Length
            if (SkeletonData[CtRunNum, RowNum, 8] == 1)
            {
                if (ImperialRadio.Checked == true) Val = Math.Round( SkeletonData[CtRunNum, RowNum, 7], 2);
                {
                    TmpDbl = Convert.ToDouble(SkeletonData[CtRunNum, RowNum, 7]);
                    TmpDbl *= 25.4;
                    Val = Math.Round(TmpDbl, 2);
                }
            }
            tableModel1.Rows[RowNum].Cells[5].Data = Val;
            if (Val != null) CtRunTableValsInst[RowNum].Length = Val.ToString();
            else CtRunTableValsInst[RowNum].Length = "";

            //Sixth Column is Progress bar  if current run is an active download
            if (IsRunActiveDownload == true)
            {
                Val = 100;
                if (SkeletonData[CtRunNum, RowNum, 8] == 1) Val = 100;
                else Val = 0;  //Show Progress bar if it's a 
                tableModel1.Rows[RowNum].Cells[6].Data = Val;
            }
            else
            {
                //Sixth Column is DownloadStat
                if (SkeletonData[CtRunNum, RowNum, 8] == 1) TmpDbl = 1; //Show Green Tick Icon
                else TmpDbl = 1;                                       //Show Timer Icon
            }
            
        }


        //--------------------------------------
        //Create Table Columns
        //--------------------------------------
        void CreateColumnTables()
        {
            //Create Six Columns
            columnModel1.Columns.Add(new XPTable.Models.NumberColumn("S.No."));
            columnModel1.Columns[0].Width = 50;
            
            columnModel1.Columns.Add(new XPTable.Models.TextColumn("Time"));
            columnModel1.Columns[1].Width = 150;
            if(ImperialRadio.Checked == true)  columnModel1.Columns.Add(new XPTable.Models.NumberColumn("Distance (Ft)"));
            else columnModel1.Columns.Add(new XPTable.Models.NumberColumn("Distance (m)"));
            columnModel1.Columns[2].Width = 90;


            if (ImperialRadio.Checked == true)  columnModel1.Columns.Add(new XPTable.Models.NumberColumn("Min ID (In)"));
            else columnModel1.Columns.Add(new XPTable.Models.NumberColumn("Min ID (mm)"));
            columnModel1.Columns[3].Width = 90;

            columnModel1.Columns.Add(new XPTable.Models.TextColumn("O'Clock"));
            columnModel1.Columns[4].Width = 90;

            if (ImperialRadio.Checked == true)  columnModel1.Columns.Add(new XPTable.Models.NumberColumn("Length (In)"));
            else columnModel1.Columns.Add(new XPTable.Models.NumberColumn("Length (mm)"));
            columnModel1.Columns[5].Width = 90;



            if (IsRunActiveDownload == true)
            {
                columnModel1.Columns.Add(new XPTable.Models.ProgressBarColumn("Progress"));
                columnModel1.Columns[6].Width = 250;
            }
            else
            {
                columnModel1.Columns.Add(new XPTable.Models.ImageColumn("Status"));
                columnModel1.Columns[6].Width = 200;
            }

            Status1Lbl.Text = "";
            Status2Lbl.Text = "";
        }

        //--------------------------------------
        //Find if Currrent Run is an active download
        //--------------------------------------
        void FindIsRunActiveDownload()
        {
            int i;
            
            if (CtRunNum == LatestRunNum)
            {
                for (i = 0; i < RecCtinRun[CtRunNum]; i++)
                {
                    if (SkeletonData[CtRunNum, i, 8] != 1)
                    {
                        i = RecCtinRun[CtRunNum] + 1;
                        IsRunActiveDownload = true;
                    }
                }
            }
            else IsRunActiveDownload = false; 
        }
        //-----------------------------------------

        //-------------------------------------
        //Show Init GUI
        //-------------------------------------
        private void ShowInitGUI()
        {
            InitLbl.Visible = true;
            InitPrgrsBar.Visible = true;
            XSctnPlot.Visible = false;
            BackToMMBtn.Visible = false;
            PrevRunBtn.Visible = false;
            NextRunBtn.Visible = false;
            
            RunTypeLbl.Visible = false;
            DistanceLbl.Visible = false;
            ToolSizeLbl.Visible = false;
            LaunchDateLbl.Visible = false;
            DownloadDateLbl.Visible = false;
            Status1Lbl.Visible = false;
            Status2Lbl.Visible = false;
            
            ImperialRadio.Visible = false;
            MetricRadio.Visible = false;
            ImperialRadio.Visible = false;
            UnitLbl.Visible = false;
            RunNumLbl.Visible = false;
        }

        //-------------------------------------
        //Hide Init GUI
        //-------------------------------------
        private void HideInitGUI()
        {
            InitLbl.Visible = false;
            InitPrgrsBar.Visible = false;
            XSctnPlot.Visible = true;
            BackToMMBtn.Visible = true;
            PrevRunBtn.Visible = true;
            NextRunBtn.Visible = true;
            XSctnPlot.Visible = true;
            RunTypeLbl.Visible = true;
            DistanceLbl.Visible = true;
            ToolSizeLbl.Visible = true;
            LaunchDateLbl.Visible = true;
            DownloadDateLbl.Visible = true;
            Status1Lbl.Visible = true;
            Status2Lbl.Visible = true;
            
            MetricRadio.Visible = true;
            ImperialRadio.Visible = true;
            UnitLbl.Visible = true;
            RunNumLbl.Visible = true;
        }

        private void BackToMMBtn_Click(object sender, EventArgs e)
        {
            this.Dispose();
            Program.MainInst.Show();
        }


        //------------------------------------------------
        //Verify and Load ts.bin for the Current Run 
        //------------------------------------------------
        private bool VerifyAndLoadTS(string TSPath, int CtRun)
        {
            
            try
            {
                //Prep and Read ts.bin
                TextReader TempTxtRdr = File.OpenText(TSPath + "\\ts.bin");
                LaunchDate[CtRun] = TempTxtRdr.ReadLine();
                DownloadDate[CtRun] = TempTxtRdr.ReadLine();

                if (DownloadDate[CtRun].Length < 5) return false;

                
                TempTxtRdr.Close();
            }
            catch
            {
                return false;
            }
            

            return true;
        }

        private void table1_SelectionChanged(object sender, XPTable.Events.SelectionEventArgs e)
        {
            if ((e.NewSelectedIndicies.Length > 0) && (e.NewSelectedIndicies[0] < RecCtinRun[CtRunNum]))
            {
                CtTableSelectedIndex = e.NewSelectedIndicies[0];
                DrawXSctn(CtTableSelectedIndex);
            }
        }

        private void DrawXSctn(int SelectedIndex)
        {
            int i;
            //Calculate CtElement
            Object Val;
            int CtElement;

            System.Drawing.Pen NeedlePen = new System.Drawing.Pen(Color.Red);
            Graphics g = XSctnPlot.CreateGraphics();
            g.Clear(XSctnPlot.BackColor);

            

            Val = tableModel1.Rows[SelectedIndex].Cells[0].Data;
            CtElement = (int)Val;
            CtElement--;

            if (SkeletonData[CtRunNum, CtElement, 8] == 1)
            {
                double[] XCoords = new double[24];
                double[] YCoords = new double[24];

                NeedlePen.Width = 2;

                for (i = 0; i < 24; i++)
                {
                    //Find XCoords
                    XCoords[i] = Math.Sin((15 * i * Math.PI)/180) * (SkeletonData[CtRunNum, CtElement, (9 + i)] - 0.4);
                    XCoords[i] *= -1;
                    XCoords[i] = (XSctnPlot.Width / 2) -  (XCoords[i] * 2 * ((XSctnPlot.Width / 2) - 10) );
                    //Find YCoords
                    YCoords[i] = Math.Cos((15 * i * Math.PI) / 180) * (SkeletonData[CtRunNum, CtElement, (9 + i)] - 0.4);
                    YCoords[i] = (XSctnPlot.Height / 2) - (YCoords[i] * 2 * ((XSctnPlot.Height / 2) - 10));
                }


                for (i = 0; i < 24; i++)
                {
                    if (i < 23) g.DrawLine(NeedlePen, (float)XCoords[i], (float)YCoords[i], (float)XCoords[i + 1], (float) YCoords[i + 1]);
                    else g.DrawLine(NeedlePen, (float)XCoords[i], (float)YCoords[i], (float)XCoords[0], (float)YCoords[0]);
                }
            }

            g.Dispose();
        }

        private void XSctnPlot_Paint_1(object sender, PaintEventArgs e)
        {
            if (RecCtinRun[CtRunNum] > 0)
                DrawXSctn(CtTableSelectedIndex);
            else ClearXSctn();
        }

        private void ClearXSctn()
        {
            Graphics g = XSctnPlot.CreateGraphics();
            g.Clear(XSctnPlot.BackColor);
            g.Dispose();
        }

        private void ImperialRadio_CheckedChanged(object sender, EventArgs e)
        {
            int i;
            //--------------------------------------------
            //Adjust Table elements
            //--------------------------------------------
            //Adjust Column Names
            if (ImperialRadio.Checked == true) columnModel1.Columns[2].Text = "Distance (Ft)";
            else columnModel1.Columns[2].Text = "Distance (m)";

            if (ImperialRadio.Checked == true) columnModel1.Columns[3].Text = "Min ID (In)";
            else columnModel1.Columns[3].Text = "Min ID (mm)";

            if (ImperialRadio.Checked == true) columnModel1.Columns[5].Text = "Length (In)";
            else columnModel1.Columns[5].Text = "Length (mm)";

            //Adjust 
            for (i = 0; i < RecCtinRun[CtRunNum]; i++)
            {
                Object Val;

                double TmpDbl;
                //Third Column is Distance
                if (SkeletonData[CtRunNum, i, 8] != 1)
                {
                    if (ToolParamsInst[CtRunNum].IsCtRunTimeBased == 1) TmpDbl = Convert.ToDouble(SkeletonData[CtRunNum, i, 2]); //Distance in Sec Param
                    else TmpDbl = Convert.ToDouble(SkeletonData[CtRunNum, i, 0]); //Distance in Primary field

                    TmpDbl /= 48;
                    if ((ToolParamsInst[CtRunNum].ToolSize >= 16) && (ToolParamsInst[CtRunNum].ToolSize <= 22)) TmpDbl *= 2;

                    if (MetricRadio.Checked == true) TmpDbl *= 0.3048;
                    Val = Math.Round(TmpDbl, 2);
                }
                else
                {
                    if (ImperialRadio.Checked == true) Val = Math.Round(SkeletonData[CtRunNum, i, 4], 2);
                    else
                    {
                        TmpDbl = Convert.ToDouble(SkeletonData[CtRunNum, i, 4]);
                        TmpDbl *= 0.3048;
                        Val = Math.Round(TmpDbl, 2);
                    }
                }
                tableModel1.Rows[i].Cells[2].Data = Val;

                Val = null;
                //Fourth Column is MinID
                if (SkeletonData[CtRunNum, i, 8] == 1)
                {
                    if (ImperialRadio.Checked == true) Val = Math.Round(SkeletonData[CtRunNum, i, 5], 2);
                    else
                    {
                        TmpDbl = Convert.ToDouble(SkeletonData[CtRunNum, i, 5]);
                        TmpDbl *= 25.4;
                        Val = Math.Round(TmpDbl, 2);
                    }
                }
                tableModel1.Rows[i].Cells[3].Data = Val;

                
                Val = null;
                //Sixth Colum is Length
                if (SkeletonData[CtRunNum, i, 8] == 1)
                {
                    if (ImperialRadio.Checked == true) Val = Math.Round(SkeletonData[CtRunNum, i, 7], 2);
                    {
                        TmpDbl = Convert.ToDouble(SkeletonData[CtRunNum, i, 7]);
                        TmpDbl *= 25.4;
                        Val = Math.Round(TmpDbl, 2);
                    }
                }
                tableModel1.Rows[i].Cells[5].Data = Val;
            }

            //Populate Run Specific Fields - Labels
            PopulateRunLabels();

            if (ImperialRadio.Checked == true) Program.MainInst.IsImperialPref = 1;
            else Program.MainInst.IsImperialPref = 0;
            Program.MainInst.WriteConfigFile();

        }

        
        //-------------------------------------------------------------------
        //Download and Prcs BG Wrkr
        //-------------------------------------------------------------------
        private void DwnldPrcsBGWrkr_DoWork(object sender, DoWorkEventArgs e)
        {
            //-----------------------------------------------
            //Find out the Records that need to be downloaded and processed
            //-----------------------------------------------
            double[] RecSizesRaw = new double[RecCtinRun[CtRunNum]];
            int[] RecDownloadOrder = new int[RecCtinRun[CtRunNum]];
            int i, DownloadRecCt, j ;
            DownloadRecCt = 0;
            for (i = 0; i < RecCtinRun[CtRunNum]; i++)
            {
                if (SkeletonData[CtRunNum, i, 8] != 1)
                {
                    RecSizesRaw[DownloadRecCt] = SkeletonData[CtRunNum, i, 1] - SkeletonData[CtRunNum, i, 0];
                    RecDownloadOrder[DownloadRecCt] = i;
                    DownloadRecCt++;
                }
            }
            double[] RecSizesSorted = new double[DownloadRecCt];
            Array.Copy(RecSizesRaw, 0, RecSizesSorted, 0, DownloadRecCt);
            Array.Sort(RecSizesSorted, RecDownloadOrder);
            
            //------------------------------------
            //Find COMPort
            //-------------------------------------
            if ((Program.MainInst.ComPortName == null) || (Program.MainInst.ComPortName == "None"))
            {
                Program.MainInst.ComPortName = Program.MainInst.FindCOMPort();
                if (Program.MainInst.ComPortName == "None") return;
            }
            
            //-----------------------------------------------
            //Start Downloading
            //-----------------------------------------------
            for (i = 0; i < DownloadRecCt; i++)
            {
                CtDownloadRecNum = RecDownloadOrder[i];

                RecsLeftToDownload = DownloadRecCt - i;
                DwnldPrcsInst = new DownloadAndPrcs();

                DownloadRet = DwnldPrcsInst.DownloadARecord(ToolParamsInst[CtRunNum], SkeletonData, CtRunNum, RecDownloadOrder[i], DwnldPrcsBGWrkr);
                if (DownloadRet != 1) return;

                int PrcsReturn = DwnldPrcsInst.ProcessARecord(ToolParamsInst[CtRunNum], SkeletonData, CtRunNum, RecDownloadOrder[i], DwnldPrcsBGWrkr);
                if (PrcsReturn != 1) return;

                //Update SkeletonData and File
                SkeletonData[CtRunNum, RecDownloadOrder[i], 3] = DwnldPrcsInst.PrcsReturnValsInst.TimeOfEvent;
                SkeletonData[CtRunNum, RecDownloadOrder[i], 4] = DwnldPrcsInst.PrcsReturnValsInst.DistanceOfEvent;
                SkeletonData[CtRunNum, RecDownloadOrder[i], 5] = DwnldPrcsInst.PrcsReturnValsInst.MinID;
                SkeletonData[CtRunNum, RecDownloadOrder[i], 6] = DwnldPrcsInst.PrcsReturnValsInst.OClock;
                SkeletonData[CtRunNum, RecDownloadOrder[i], 7] = DwnldPrcsInst.PrcsReturnValsInst.Length;
                SkeletonData[CtRunNum, RecDownloadOrder[i], 8] = 1;

                for(j=0;j<24;j++) SkeletonData[CtRunNum, RecDownloadOrder[i], (9+j)] = DwnldPrcsInst.PrcsReturnValsInst.XSctn[j];
                
                //Update SkeletonData File
                WriteSkeletonFile();

                //Set variables to update Table
                NewDataAvl = 1;
                NewDataRow = RecDownloadOrder[i];
            }

        }

        //-------------------------------------------------------------------
        //Download and Prcs BG Wrkr -  Run Worker Completed
        //-------------------------------------------------------------------

        private void DwnldPrcsBGWrkr_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            //If Invalid COM Port - Show it on the status message
            if (Program.MainInst.ComPortName == "None")
            {
                Status1Lbl.Left = 220;
                Status1Lbl.Text = "   Insert RS-Caliper Dongle ";
            }
            else
            {
                Status1Lbl.Text = "";
                Status2Lbl.Text = "";
                IsRunActiveDownload = false;
            }

            //If DownloadRet has anything other than 1, display appropriate message

        }

        //-------------------------------------------------------------------
        //Download and Prcs BG Wrkr -  Progress Changed
        //-------------------------------------------------------------------
        private void DwnldPrcsBGWrkr_ProgressChanged(object sender, ProgressChangedEventArgs e)
        {
            int DownloadStat, PrgrsPcnt;
            DownloadStat = Math.DivRem(e.ProgressPercentage, 256, out PrgrsPcnt);
            //MessageBox.Show("Prgrs = " + PrgrsPcnt.ToString() + "  " + "DownloadStat: " + DownloadStat.ToString());

            //Progress Bar Update
            object Pcntval;
            Pcntval = PrgrsPcnt;
            tableModel1.Rows[CtDownloadRecNum].Cells[6].Data = Pcntval;

            Status1Lbl.Left = 413;
            Status1Lbl.Text = "Downloading";
            Status2Lbl.Text = RecsLeftToDownload.ToString() + " Records to download";

        } 


        private const int CP_NOCLOSE_BUTTON = 0x200;
        protected override CreateParams CreateParams
        {
            get
            {
                CreateParams myCp = base.CreateParams;
                myCp.ClassStyle = myCp.ClassStyle | CP_NOCLOSE_BUTTON;
                return myCp;
            }
        }

        private void EventTmr_Tick(object sender, EventArgs e)
        {
            if (NewDataAvl == 1)
            {
                //Update Time, Distance, MinID, O'Clock, Length
                LoadATableRow(NewDataRow);
                NewDataAvl = 0;
            }
        }


        private int WriteSkeletonFile()
        {
            int i, j;
            string TempOutString;
            TempOutString = "";
            
            try
            {
                FileStream TempStream = File.Create(Program.MainInst.RootDrive + Program.MainInst.JobNo + CtRunNum.ToString("00") + "\\skeleton.bin");
                TempStream.Close();

                StreamWriter FileWriter = new StreamWriter(Program.MainInst.RootDrive + Program.MainInst.JobNo + CtRunNum.ToString("00") + "\\skeleton.bin");

                FileWriter.WriteLine("RecStartLoc,RecEndLoc,SecValue,Time,Distance,MinID,O'Clock,Length,DownloadStat");
                for (i = 0; i < RecCtinRun[CtRunNum]; i++)
                {
                    TempOutString = "";
                    //Convert each element to string
                    for (j = 0; j < (9 + 24); j++)
                    {
                        TempOutString += SkeletonData[CtRunNum, i, j].ToString("0.000");
                        if (j != 32) TempOutString += ",";
                    }
                    //Write to line to the stream
                    FileWriter.WriteLine(TempOutString);
                }
                FileWriter.Close();
            }
            catch
            {
                //Promptly exit
                MessageBox.Show("Unable to Write Records - Please Contact EnviroCal", "Error", MessageBoxButtons.OK, MessageBoxIcon.Stop);
                
            }
            return 0;
        }

        private void PrevRunBtn_Click(object sender, EventArgs e)
        {
            CtRunNum--;
            LoadCtRunOnTable();
        }

        private void NextRunBtn_Click(object sender, EventArgs e)
        {
            CtRunNum++;
            LoadCtRunOnTable();
        }

        private void MetricRadio_CheckedChanged(object sender, EventArgs e)
        {

        }

        private void CreateReportBtn_Click(object sender, EventArgs e)
        {
            //Check to see if there is any more data ready to download
            if (IsRunActiveDownload == false)
            {
                CreateReport CreateRepInst = new CreateReport();
                CreateRepInst.ShowDialog();
            }
            else
            {
                if (MessageBox.Show("There are still records to download. Do you want to continue Generating Report?", "Warning", MessageBoxButtons.YesNo, MessageBoxIcon.Question) == DialogResult.Yes)
                {
                    CreateReport CreateRepInst = new CreateReport();
                    CreateRepInst.ShowDialog();
                }

            }
        }

        private void ExitTmr_Tick(object sender, EventArgs e)
        { 
            Program.MainInst.Show();
            this.Dispose();
            
        }



    }
}
