﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
//using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.IO.Ports;


namespace WindowsFormsApplication1
{
    public partial class Launch : Form
    {
        bool LaunchResult;
        bool WirelineLaunchstat;
        bool BgWrkrReqCancel;

        bool IsWirelineBoxFound;
        string WirelineComPortName;

        byte[] WirelineOutPacket;
        public Launch()
        {
            InitializeComponent();
        }

        private void Launch_Load(object sender, EventArgs e)
        {
            this.Width = 496;
            this.Height = 457;
            WirelineComPortName = "None";

            SetDefaultRadioBtns();
            Program.MainInst.ReadConfigFile();
            if ((Program.MainInst.AdminMode == 0) && (Program.MainInst.IsWirelineMode == false))
            {
                SetLaunchingModeGUI();
            }
            else
            {
                if (Program.MainInst.IsWirelineMode == true)
                {
                    DisplayLaunchingModeGUI();
                    IsWirelineBoxFound = false;
                    WirelineBGWrkr.RunWorkerAsync();
                }

                else SetSelectionModeGUI();
                
            }
            LaunchResult = false;
            BgWrkrReqCancel = false;
        }

        private void SetDefaultsBtn_Click(object sender, EventArgs e)
        {
            SetDefaultRadioBtns();
        }

        //------------------------------------
        //Default Radio button States
        //------------------------------------
        private void SetDefaultRadioBtns()
        {
            FrequencyRadio.Checked = true;
            SlowSpeedRadio.Checked = true;
            ContinousRadio.Checked = true;
        }

        private void SetSelectionModeGUI()
        {
            LaunchLbl.Visible = true;
            LaunchModeGrp.Visible = true;
            SpdGrpBox.Visible = true;
            XtergroupBox.Visible = true;
            LaunchBtn.Visible = true;
            SetDefaultsBtn.Visible = true;
            BacktoMMBtn.Visible = true;
            LaunchignToolLbl.Visible = false;
            LaunchingToolPrgrsbar.Visible = false;
        }

        private void SetLaunchingModeGUI()
        {
            LaunchLbl.Visible = false;
            LaunchModeGrp.Visible = false;
            SpdGrpBox.Visible = false;
            XtergroupBox.Visible = false;
            LaunchBtn.Visible = false;
            SetDefaultsBtn.Visible = false;
            BacktoMMBtn.Visible = false;
            LaunchignToolLbl.Visible = true;
            LaunchingToolPrgrsbar.Visible = true;
            WirelineFrame.Visible = false;
            this.Width = 496;
            //Launch BGWrkr
            BGWrkr.RunWorkerAsync();
        }

        private void DisplayLaunchingModeGUI()
        {
            LaunchLbl.Visible = false;
            LaunchModeGrp.Visible = false;
            SpdGrpBox.Visible = false;
            XtergroupBox.Visible = false;
            LaunchBtn.Visible = false;
            SetDefaultsBtn.Visible = false;
            BacktoMMBtn.Visible = false;
            LaunchignToolLbl.Visible = true;
            LaunchingToolPrgrsbar.Visible = true;
            WirelineFrame.Visible = false;
        }

        private void BGWrkr_DoWork(object sender, DoWorkEventArgs e)
        {
            //Test Read Sector
            byte[] ReadData = new byte[513];
            byte[] FreqBytes = new byte[4];

            //----------------------------
            //Write Frequency to Sector
            //----------------------------
            ReadData = Program.MainInst.ReadSectorFromTool(11, false);
            if (ReadData[0] != 1) return;
            
            //Calculate Frequency Bytes
            if (SlowSpeedRadio.Checked == true) FreqBytes = BitConverter.GetBytes(1056);
            else FreqBytes = BitConverter.GetBytes(2112);
            ReadData[5] = FreqBytes[3];
            ReadData[6] = FreqBytes[2];
            ReadData[7] = FreqBytes[1];
            ReadData[8] = FreqBytes[0];

            if (Program.MainInst.WriteSectorToTool(11, ReadData, 1, false) != 1) return;

            //Write Transmitter Mode
            ReadData = Program.MainInst.ReadSectorFromTool(0, false);
            if (ReadData[0] != 1) return;
            if (ContinousRadio.Checked == true) ReadData[16] = 1;
            else ReadData[16] = 0;
            if (Program.MainInst.WriteSectorToTool(0, ReadData, 1, false) != 1) return;

            
            //Issue Launch for Wireline Box
            if (WirelineComPortName != "None") if (!IssueWirelineLaunch()) return;

            WirelineLaunchstat = true;
   
            //Issue Launch Command
            if (DistanceRadio.Checked == true)
            {
                if (Program.MainInst.SendSingleCmdCmpr((byte)'l', 4, Encoding.ASCII.GetBytes("Done"), false) != 1) return;
            }
            else
            {
                if (Program.MainInst.SendSingleCmdCmpr((byte)'t', 4, Encoding.ASCII.GetBytes("Done"), false) != 1) return;
            }
         
            LaunchResult = true;
        }

        private void BGWrkr_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            bool LocalPrcsSuccess = false;

            if (BgWrkrReqCancel == false)
            {
                LaunchingToolPrgrsbar.Value = 100;

                if (WirelineLaunchstat == false)
                {
                    LaunchignToolLbl.ForeColor = Color.Red;
                    
                    LaunchignToolLbl.Text = "ERROR : Wireline Box not Launched /n- Contact EnviroCal";
                    Tmr.Interval = 3000;
                    Tmr.Enabled = true;
                    Tmr.Start();
                    return;
                }
                if (LaunchResult == true)
                {
                    try
                    {
                        string RunNumDir;

                        //Write To the Config file
                        Program.MainInst.ReadConfigFile();
                        Program.MainInst.CtRunNum++;
                        Program.MainInst.IsToolLaunched = 1;
                        Program.MainInst.WriteConfigFile();

                        int TmpInt;
                        TmpInt = Program.MainInst.CtRunNum;

                        RunNumDir = Program.MainInst.RootDrive + Program.MainInst.JobNo + TmpInt.ToString("00");
                        //Create RunNum Directory
                        if (Directory.Exists(RunNumDir) == false)
                        {
                            DirectoryInfo di=  Directory.CreateDirectory(RunNumDir);
                            di.Attributes = FileAttributes.Directory | FileAttributes.Hidden;
                            
                        }
                        //Create TimeStamp file

                        string DateTimeString;
                        DateTimeString = DateTime.Now.ToString("MM/dd/yyyy HH:mm:ss.fff");
                        //Write the Current date and Time
                        FileStream TempFilePtr;
                        TempFilePtr = File.Open(RunNumDir + "\\" + "ts.bin", FileMode.Create);
                        TempFilePtr.Write(Encoding.ASCII.GetBytes(DateTimeString), 0, DateTimeString.Length);
                        TempFilePtr.Close();

                        LocalPrcsSuccess = true;


                    }
                    catch
                    {
                        LaunchignToolLbl.ForeColor = Color.Red;
                        LaunchignToolLbl.Text = "ERROR : Config Files Not Updated - \nTool Successfully Launched - Contact EnviroCal";

                    }
                }

                if (LocalPrcsSuccess == true)
                {
                    if (LaunchResult == true)
                    {
                        LaunchignToolLbl.Text = "Tool Launched";
                        LaunchingToolPrgrsbar.Style = ProgressBarStyle.Blocks;
                    }
                    else
                    {
                        LaunchignToolLbl.ForeColor = Color.Red;
                        LaunchignToolLbl.Text = "ERROR : Tool NOT Launched";

                    }
                    //If Admin mode is selected, release the admin mode
                    if (Program.MainInst.AdminMode == 1)
                    {
                        Program.MainInst.AdminMode = 0;
                        Program.MainInst.WriteConfigFile();
                    }
                }

                Tmr.Interval = 3000;
                Tmr.Enabled = true;
                Tmr.Start();
            }
            else
            {
                Program.MainInst.Show();
                this.Dispose();
            }
        }

        private void LaunchBtn_Click(object sender, EventArgs e)
        {
            if (WirelineComPortName != "None")
            {
                //Validate Wireline entries
                WirelineOutPacket = ValidateWirelineEntries();

                if (WirelineOutPacket[0] > 0) SetLaunchingModeGUI();
            }
            else
            {
                SetLaunchingModeGUI();
            }
        }

        private void Launch_FormClosed(object sender, FormClosedEventArgs e)
        {
            this.Dispose();
            Program.MainInst.Dispose();
            BGWrkr.Dispose();
            Application.Exit();
        }

        private void Tmr_Tick(object sender, EventArgs e)
        {
            Program.MainInst.Show();
            this.Dispose();
        }

        private void DistanceRadio_CheckedChanged(object sender, EventArgs e)
        {
            if (DistanceRadio.Checked == true)
                SpdGrpBox.Enabled = false;
            else SpdGrpBox.Enabled = true;
        }

        private void BacktoMMBtn_Click(object sender, EventArgs e)
        {
            if (BGWrkr.IsBusy == true)
            {
                BGWrkr.CancelAsync();
                BgWrkrReqCancel = true;
            }
            else
            {
                Program.MainInst.Show();
                this.Dispose();
            }
        }

        private void WirelineBGWrkr_DoWork(object sender, DoWorkEventArgs e)
        {
            SerialPort Serial = new SerialPort();
            Byte[] RetVal = new Byte[100];
            int i;

            //----------------------------------------
            //Get list of Serial Ports and Find out which one is our Zigbee
            //----------------------------------------
            string[] ports = SerialPort.GetPortNames();

            //Set Common Parameters for all Ports
            Serial.BaudRate = 921600;
            Serial.StopBits = StopBits.One;
            Serial.Parity = Parity.None;
            Serial.RtsEnable = false;
            Serial.ReadTimeout = 500;

            foreach (string port in ports)
            {
                try
                {
                    if (port != Program.MainInst.ComPortName)
                    {
                        Serial.PortName = port;
                        Serial.Open();

                        Serial.Write("i");

                        for (i = 0; i < 4; i++) RetVal[i] = (byte) Serial.ReadByte();

                        if ((RetVal[0] == 'W') && (RetVal[1] == 'i') && (RetVal[2] == 'r') && (RetVal[3] == 'e'))
                        {
                            IsWirelineBoxFound = true;
                        }
                        
                        WirelineComPortName = port;

                    }
                    if(Serial.IsOpen) Serial.Close();
                }
                catch
                {
                    if(Serial.IsOpen) Serial.Close();
                }
            }
               

        }

        private void WirelineBGWrkr_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            //Adjust the form width and display the Wireline frame
            SetSelectionModeGUI();
            this.Width = 800;
            WirelineFrame.Visible = true;
            if (WirelineComPortName == "None") WirelineCOMLbl.Text = "Wireline Box Not found";
            else WirelineCOMLbl.Text = "Wireline box on " + WirelineComPortName;
            WheelUnitcombo.SelectedIndex = 0;
        }

        private byte[] ValidateWirelineEntries()
        {
            byte[] OutByte = new byte[17];
            double tempdbl;
            int i;

            OutByte[0] = 1;
            OutByte[1] = (byte) 'l';
            OutByte[2] = (byte)'p';
            OutByte[3] = (byte)'a';
            OutByte[4] = (byte)'c';

            //Wireline Label
            try
            {
                byte[] TempByteArray = new byte[4];
                //Wheel Circumference loading
                tempdbl = Convert.ToDouble(WheelCirTextbox.Text);
                if (WheelUnitcombo.SelectedIndex == 0) tempdbl *= 100;
                else tempdbl *= (25.4 * 100);
                UInt32 TUint32 = (UInt32)tempdbl;
                TempByteArray = BitConverter.GetBytes(TUint32);
                for (i = 0; i < 4; i++) OutByte[5 + i] = TempByteArray[3 - i];

                //Pulses Per Revolution
                TUint32 = Convert.ToUInt32(PulsePerRevTxtbox.Text);
                TempByteArray = BitConverter.GetBytes(TUint32);
                for (i = 0; i < 4; i++) OutByte[9 + i] = TempByteArray[3 - i];

                //Calculate Frequency Bytes
                if (SlowSpeedRadio.Checked == true) TempByteArray = BitConverter.GetBytes(1056);
                else TempByteArray = BitConverter.GetBytes(2112);
                for (i = 0; i < 4; i++) OutByte[13 + i] = TempByteArray[3 - i];
                
            }
            catch
            {
                OutByte[0] = 0;
                MessageBox.Show("Invalid Wireline Entries", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }

            return OutByte;

        }


        //--------------------------------------------
        //Issue Wireline Launch
        //--------------------------------------------
        private Boolean IssueWirelineLaunch()
        {
            int i;
            SerialPort Serial = new SerialPort();
            //Set Common Parameters for all Ports
            Serial.BaudRate = 921600;
            Serial.StopBits = StopBits.One;
            Serial.Parity = Parity.None;
            Serial.RtsEnable = false;
            Serial.ReadTimeout = 500;
            Serial.PortName = WirelineComPortName;

            try
            {
                Serial.Open();
                for (i = 0; i < 16; i++) Serial.Write(WirelineOutPacket, (i + 1), 1);

                byte[] ReturnByte = new byte[4];
                for (i = 0; i < 4; i++) ReturnByte[i] = (byte) Serial.ReadByte();

                if ((ReturnByte[0] == 'D') && (ReturnByte[1] == 'o') && (ReturnByte[2] == 'n') && (ReturnByte[3] == 'e')) return true;
                else return false;

            }
            catch
            {
                return false;
            }
            
        }
    }
}
