﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
//using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.IO.Ports;


namespace WindowsFormsApplication1
{
    public partial class Main : Form
    {
        //Global Control Variables
        public string   ModeRequested;
        public string   ComPortName;
        public string   RootDrive;

        //Global Data Variables
        public int      CtRunNum;
        public int      IsToolLaunched;
        public string   JobNo;
        public string   CompName;
        public Single   ToolSize;
        public int      NoArms;
        public int      AdminMode;
        public int      IsImperialPref;
        public string   City;
        public string   State;
        public string   Country;
        public string   QC;
        public string   QCDate;

        //Wireline Control Variables
        public bool     IsWirelineMode;

        //Global Instances
        public ViewRuns ViewRunsInst;

        //File specific global variables
        string LocalComPortName;
        Boolean AltWexe, AltIexe, AltRexe, AltEexe;

        public Main()
        {
            InitializeComponent();
        }

        

        private void Launchbtn_Click(object sender, EventArgs e)
        {
            ModeRequested = "Launch";
            if ((AltWexe == true) && (AltIexe == true) && (AltRexe == true) && (AltEexe == true)) IsWirelineMode = true;
            else IsWirelineMode = false;
            ClearKeyboardflags();
            EstabCommLaunch();
        }

        private void DownloadBtn_Click(object sender, EventArgs e)
        {
            ModeRequested = "Download";
            ClearKeyboardflags();
            EstabCommLaunch();
        }

        private void ViewRunsBtn_Click(object sender, EventArgs e)
        {
            ViewRunsInst = new ViewRuns();
            ViewRunsInst.Show();
            ClearKeyboardflags();
            ModeRequested = "ViewRuns";
            this.Hide();
        }

        private void DiagBtn_Click(object sender, EventArgs e)
        {
            ModeRequested = "Diagnostics";
            ClearKeyboardflags();
            EstabCommLaunch();
        }

        private void EstabCommLaunch()
        {
            EstablishingComm EstabCommInst = new EstablishingComm();
            EstabCommInst.Show();
            this.Hide();
            
        }

        private void Main_Load(object sender, EventArgs e)
        {
            RootDrive = GetRoot();
            if (RootDrive == "")
            {
                MessageBox.Show("Config File Not found. Please Contact EnviroCal");
                Application.Exit();
            }

            if (ReadConfigFile() == 0)
            {
                MessageBox.Show("Error Reading Config File. Please Contact EnviroCal");
                Application.Exit();
            }

            //Update Status Bar
            CompanyNameLbl.Text = CompName + "                                               ";
            JobNoLbl.Text = "Job Number: " + JobNo + "                                                     ";
            ToolSizeLbl.Text = "Tool Size: " + ToolSize.ToString() + " inch                                   " ;
            
        }

        public byte[] ReadSectorFromTool(UInt32 SectorNum, bool SupressError)
        {
            //Error Code Definitions
            //1 - Success
            //2 - Dongle Unavailable
            //3 - Tool Not in Range or Unavailable

            byte[] OutData = new byte[513];
            OutData[0] = 2;
            int i, j;

            byte[] SctrAddrBytes = BitConverter.GetBytes(SectorNum);
            for (j = 0; j < 25; j++)
            {
                try
                {

                    ToolSerPort.PortName = ComPortName;
                    ToolSerPort.ReadTimeout = 300;
                    ToolSerPort.Open();


                    //Issue Read Command
                    ToolSerPort.Write("r");

                    //Read and Validate Response to the Read Command
                    for (i = 0; i < 3; i++)
                    {
                        OutData[i] = (byte)ToolSerPort.ReadByte();
                    }

                    //Send Sector Address in Byte form - Big Endian Style
                    //Send 512 Bytes of Data
                    //Get Confirmation
                    for (i = 0; i < 4; i++)
                    {
                        ToolSerPort.Write(SctrAddrBytes, (3 - i), 1);
                    }

                    for (i = 0; i < 512; i++)
                    {
                        OutData[i+1] = (byte) ToolSerPort.ReadByte();
                    }

                    OutData[0] = 1;
                    j = 30;
                    ToolSerPort.Close();
                }
                catch (TimeoutException)
                {
                    OutData[0] = 3;
                    if (ToolSerPort.IsOpen == true) ToolSerPort.Close();
                }
                catch
                {
                    OutData[0] = 2;
                    if (ToolSerPort.IsOpen == true) ToolSerPort.Close();
                }
            }

            //Exception Handling
            if (SupressError == false)
            {
                if (OutData[0] == 2) MessageBox.Show("Dongle Not Plugged in", "Error", MessageBoxButtons.OK, MessageBoxIcon.Stop);
                else if (OutData[0] == 3) MessageBox.Show("Tool Not in Range or Turned OFF", "Error", MessageBoxButtons.OK, MessageBoxIcon.Stop);
            }
            
            return OutData;
        }

        public byte WriteSectorToTool(int SectorNum, byte[] ToolData, int offset, bool SupressError)
        {
            byte RetVal = 0;

            //Error Code Definitions
            //1 - Success
            //2 - Dongle Unavailable
            //3 - Tool Not in Range or Unavailable

            byte[] OutData = new byte[4];
            RetVal = 2;
            int i, j;

            byte[] SctrAddrBytes = BitConverter.GetBytes(SectorNum);
            for (j = 0; j < 25; j++)
            {
                try
                {

                    ToolSerPort.PortName = ComPortName;
                    ToolSerPort.ReadTimeout = 300;
                    ToolSerPort.Open();


                    //Issue Write Command
                    ToolSerPort.Write("w");

                    //Read and Validate Response to the Write Command
                    for (i = 0; i < 3; i++)
                    {
                        OutData[i] = (byte)ToolSerPort.ReadByte();
                    }

                    //Send Sector Address in Byte form - Big Endian Style
                    //Send 512 Bytes of Data
                    //Get Confirmation
                    for (i = 0; i < 4; i++)
                    {
                        ToolSerPort.Write(SctrAddrBytes, (3 - i), 1);
                    }

                    for (i = 0; i < 512; i++)
                    {
                        ToolSerPort.Write(ToolData, (i+offset), 1);
                    }

                    for (i = 0; i < 4; i++)
                    {
                        OutData[i] = (byte) ToolSerPort.ReadByte();
                    }

                    if ((OutData[0] == 'D') && (OutData[1] == 'o') && (OutData[2] == 'n') && (OutData[3] == 'e'))
                    {
                        RetVal = 1;
                        j = 30;
                    }
                    else RetVal = 2;
                    ToolSerPort.Close();
                }
                catch (TimeoutException)
                {
                    RetVal = 3;
                    if (ToolSerPort.IsOpen == true) ToolSerPort.Close();
                }
                catch
                {
                    RetVal = 2;
                    if (ToolSerPort.IsOpen == true) ToolSerPort.Close();
                }
            }

            //Exception Handling
            if (SupressError == false)
            {
                if (OutData[0] == 2) MessageBox.Show("Dongle Not Plugged in", "Error", MessageBoxButtons.OK, MessageBoxIcon.Stop);
                else if (OutData[0] == 3) MessageBox.Show("Tool Not in Range or Turned OFF", "Error", MessageBoxButtons.OK, MessageBoxIcon.Stop);
            }

            return RetVal;
        }

        //--------------------------
        //Send Single Command - Compare
        //--------------------------
        public byte SendSingleCmdCmpr(byte CmdCode, int ResponseLength, byte[] ResponseData, bool SupressError)
        {
            byte RetVal = 2;
            byte[] CmdCodeArray = new byte[1];
            int i, j;
            byte[] OutData = new byte[ResponseLength];

            CmdCodeArray[0] = CmdCode;
            for (j = 0; j < 20; j++)
            {
                try
                {
                    ToolSerPort.PortName = ComPortName;
                    ToolSerPort.ReadTimeout = 300;
                    ToolSerPort.Open();
                    ToolSerPort.Write(CmdCodeArray, 0, 1);

                    for (i = 0; i < ResponseLength; i++)
                    {
                        OutData[i] = (byte)ToolSerPort.ReadByte();
                    }

                    ToolSerPort.Close();

                    //Check the response with the original
                    int CmprResult = 0;

                    for (i = 0; i < ResponseLength; i++)
                    {
                        if (OutData[i] != ResponseData[i])
                        {
                            CmprResult = 1;
                        }
                    }
                    if (CmprResult == 0)
                    {
                        j = 25;
                        RetVal = 1;
                    }
                    else RetVal = 4;

                }
                catch (TimeoutException)
                {
                    RetVal = 3;
                    if (ToolSerPort.IsOpen == true) ToolSerPort.Close();
                }
                catch
                {
                    RetVal = 2;
                    if (ToolSerPort.IsOpen == true) ToolSerPort.Close();
                }
            }

            //Exception Handling
            if (SupressError == false)
            {
                if (RetVal == 2) MessageBox.Show("Dongle Not Plugged in", "Error", MessageBoxButtons.OK, MessageBoxIcon.Stop);
                else if (RetVal == 3) MessageBox.Show("Tool Not in Range or Turned OFF", "Error", MessageBoxButtons.OK, MessageBoxIcon.Stop);
                else if (RetVal == 4) MessageBox.Show("Improper Response. Restart the Tool", "Error", MessageBoxButtons.OK, MessageBoxIcon.Stop);
            }
            
            return RetVal;
        }


        //--------------------------
        //Send Single Command - Compare
        //--------------------------
        public byte[] SendSingleCmd(byte CmdCode, int ResponseLength,  bool SupressError)
        {
            byte[] CmdCodeArray = new byte[1];
            int i, j;
            byte[] OutData = new byte[ResponseLength + 1];

            CmdCodeArray[0] = CmdCode;
            for (j = 0; j < 20; j++)
            {
                try
                {
                    ToolSerPort.PortName = ComPortName;
                    ToolSerPort.ReadTimeout = 300;
                    ToolSerPort.Open();
                    ToolSerPort.Write(CmdCodeArray, 0, 1);

                    for (i = 0; i < ResponseLength; i++)
                    {
                        OutData[i+1] = (byte)ToolSerPort.ReadByte();
                    }

                    ToolSerPort.Close();

                    j = 25;
                    OutData[0] = 1;
                }
                catch (TimeoutException)
                {
                    OutData[0] = 3;
                    if (ToolSerPort.IsOpen == true) ToolSerPort.Close();
                }
                catch
                {
                    OutData[0] = 2;
                    if (ToolSerPort.IsOpen == true) ToolSerPort.Close();
                }
            }

            //Exception Handling
            if (SupressError == false)
            {
                if (OutData[0] == 2) MessageBox.Show("Dongle Not Plugged in", "Error", MessageBoxButtons.OK, MessageBoxIcon.Stop);
                else if (OutData[0] == 3) MessageBox.Show("Tool Not in Range or Turned OFF", "Error", MessageBoxButtons.OK, MessageBoxIcon.Stop);
                
            }

            return OutData;
        }


        //--------------------------------------
        //Extract Sensor Data Packet
        //--------------------------------------
        public double[] ExtractSensorPacket(int NoArms, bool SupressError)
        {
            double[] OutData = new double[NoArms + 3];
            byte[] ReadPacket = new byte[(NoArms * 2) + 2];
            int i, j;

            for (j = 0; j < 25; j++)
            {
                try
                {
                    ToolSerPort.PortName = ComPortName;
                    ToolSerPort.ReadTimeout = 100;
                    ToolSerPort.Open();
                    ToolSerPort.Write("s");


                    for (i = 0; i < ((NoArms * 2) + 2); i++)
                    {
                        ReadPacket[i] = (byte)ToolSerPort.ReadByte();
                    }

                    //Parse Sensor Values and Load it to the output buffer
                    for (i = 0; i < NoArms; i++)
                    {
                        byte[] TempByte = new byte[2];
                        TempByte[1] = ReadPacket[(2 * i)];
                        TempByte[0] = ReadPacket[(2 * i) + 1];
                        OutData[i + 1] = BitConverter.ToInt16(TempByte, 0);
                        OutData[i + 1] /= 4096;
                        OutData[i + 1] = 1 - OutData[i + 1];
                    }

                    //Parse Orientation Value
                    OutData[1 + NoArms] = ((ReadPacket[(NoArms * 2)] & 127) * 256) + (ReadPacket[(NoArms * 2) + 1]);
                    OutData[1 + NoArms] *= 0.025;

                    //Parse Odo Value
                    OutData[2 + NoArms] = ReadPacket[(NoArms * 2)] & 128;

                    ToolSerPort.Close();

                    j = 25;
                    OutData[0] = 1;
                }
                catch (TimeoutException)
                {
                    OutData[0] = 3;
                    if (ToolSerPort.IsOpen == true) ToolSerPort.Close();
                }
                catch
                {
                    OutData[0] = 2;
                    if (ToolSerPort.IsOpen == true) ToolSerPort.Close();
                }
            }

            //Exception Handling
            if (SupressError == false)
            {
                if (OutData[0] == 2) MessageBox.Show("Dongle Not Plugged in", "Error", MessageBoxButtons.OK, MessageBoxIcon.Stop);
                else if (OutData[0] == 3) MessageBox.Show("Tool Not in Range or Turned OFF", "Error", MessageBoxButtons.OK, MessageBoxIcon.Stop);

            }

          
            return OutData;
        }

        private void Main_KeyDown(object sender, KeyEventArgs e)
        {
            if ((e.KeyCode == Keys.A) && (e.Modifiers == Keys.Alt))
            {
                   AdminMode = 1;
                WriteConfigFile();
            }

            if ((e.KeyCode == Keys.W) && (e.Modifiers == Keys.Alt)) AltWexe = true;

            if ((e.KeyCode == Keys.I) && (e.Modifiers == Keys.Alt)) AltIexe = true;

            if ((e.KeyCode == Keys.R) && (e.Modifiers == Keys.Alt)) AltRexe = true;

            if ((e.KeyCode == Keys.E) && (e.Modifiers == Keys.Alt)) AltEexe = true;

            //Read All Lines
        }


        //-----------------------------------
        //Get Root Directory
        //-----------------------------------
        private string GetRoot()
        {
            string Drive;
            int i;
            DriveInfo[] allDrives = DriveInfo.GetDrives();

            Drive = "";

            for (i = 0; i < allDrives.Length; i++)
            {
                try
                {
                    if (File.Exists(allDrives[i].RootDirectory + "est.bin"))
                    {
                        //MessageBox.Show(allDrives[i].Name);
                        Drive = allDrives[i].Name;
                        i = allDrives.Length + 2;
                    }
                }
                catch
                {
                }
            }
            return Drive;
        }
        //--------------------------------------
        //End of Get Root Directory
        //--------------------------------------

        //------------------------------------
        //Read Config File and Update Variables
        //-----------------------------------
        public int ReadConfigFile()
        {
            string[] FileConts;
            try
            {
                FileConts = File.ReadAllLines(RootDrive + "\\est.bin");
                CtRunNum = Convert.ToInt32(FileConts[0]);
                IsToolLaunched = Convert.ToInt32(FileConts[1]);
                JobNo = FileConts[2];
                CompName = FileConts[3];
                ToolSize = Convert.ToSingle(FileConts[4]);
                NoArms = Convert.ToInt32(FileConts[5]);
                AdminMode = Convert.ToInt32(FileConts[6]);
                IsImperialPref = Convert.ToInt32(FileConts[7]);
                City = FileConts[8];
                State = FileConts[9];
                Country = FileConts[10];
                QC = FileConts[11];
                QCDate = FileConts[12];
            }
            catch
            {
                return 0;
            }
            return 1;
        }
        //------------------------------------
        //End of ReadConfig File
        //------------------------------------

        //-------------------------------------
        //Write to Config File from Variables
        //-------------------------------------
        public int WriteConfigFile()
        {
            string[] FileConts = new string[13];
           
            try
            {   
                File.Delete(RootDrive + "\\est.bin");
                FileConts[0] = CtRunNum.ToString();
                FileConts[1] = IsToolLaunched.ToString();
                FileConts[2] = JobNo;
                FileConts[3] = CompName;
                FileConts[4] = ToolSize.ToString();
                FileConts[5] = NoArms.ToString();
                FileConts[6] = AdminMode.ToString();
                FileConts[7] = IsImperialPref.ToString();
                FileConts[8] = City;
                FileConts[9] = State;
                FileConts[10] = Country;
                FileConts[11] = QC;
                FileConts[12] = QCDate;

                File.WriteAllLines(RootDrive + "\\est.bin", FileConts);
                
//                Dim attribute As System.IO.FileAttributes = FileAttributes.Hidden
                System.IO.FileAttributes attribute = new System.IO.FileAttributes();
                attribute = FileAttributes.Hidden;
                File.SetAttributes(RootDrive + "\\est.bin", attribute);
            }
            catch
            {
                return 0;
            }
            return 1;
        }

        private void Main_FormClosed(object sender, FormClosedEventArgs e)
        {
            Application.Exit();
        }
        //-------------------------------------
        //End of Write To Config File
        //-------------------------------------
        
        //----------------------------------------------------
        //Find XBee ComPort
        //----------------------------------------------------
        public string FindCOMPort()
        {
            SerialPort Serial = new SerialPort();
            Byte[] RetVal = new Byte[100];
            int i;

            //----------------------------------------
            //Get list of Serial Ports and Find out which one is our Zigbee
            //----------------------------------------
            string[] ports = SerialPort.GetPortNames();

            //Set Common Parameters for all Ports
            Serial.BaudRate = 57600;
            Serial.StopBits = StopBits.One;
            Serial.Parity = Parity.None;
            Serial.RtsEnable = false;
            Serial.ReadTimeout = 2000;

            LocalComPortName = "None";
            foreach (string port in ports)
            {
                try
                {

                    //Open that COM Port at 57600, 8bits, No Parity, No Flow control
                    Serial.PortName = port;
                    Serial.Open();
                    Serial.DiscardInBuffer();
                    int j;

                    for (j = 0; j < 4; j++)
                    {

                        Serial.Write("+++");
                        for (i = 0; i < 2; i++) Serial.Read(RetVal, i, 1);

                        if ((RetVal[0] == 'O') && (RetVal[1] == 'K'))
                        {
                            LocalComPortName = port;
                            Serial.Write("ATCN" + "\r");
                            Serial.Close();
                            j = 10;
                            break;
                        }
                    }
                    Serial.Close();

                }
                catch (TimeoutException)
                {
                    if (Serial.IsOpen == true) Serial.Close();

                }
                catch
                {
                    if (Serial.IsOpen == true) Serial.Close();

                }

            }
            return LocalComPortName;
        }

        //-----------------------------------------------
        //Clear all flags
        //-----------------------------------------------
        private void ClearKeyboardflags()
        {
            AltWexe = false;
            AltIexe = false;
            AltRexe = false;
            AltEexe = false;
        }

    }



}
