﻿using System;
using System.Collections.Generic;
//using System.Linq;
using System.Text;
using System.IO;
using System.ComponentModel;

namespace WindowsFormsApplication1
{
    class PrcsReturnVals
    {
        public double TimeOfEvent;
        public double DistanceOfEvent;
        public double MinID;
        public double OClock;
        public double Length;
        public int SuccessVal;
        public double[] XSctn;
    }


    class DownloadAndPrcs
    {
        public double ProgressPrcnt;
        public int DownloadStat;    //0 - Passive, 1 - Downloading, 3 - Tool not in range, 2 - Dongle Issues, 4 - File Issues
        public bool CancelPrcs;

        public PrcsReturnVals PrcsReturnValsInst;
        //---------------------------------
        //Download A Record
        //---------------------------------
        public int DownloadARecord(ViewRuns.LatestToolParams ToolParamsInst, double[,,] SkeletonData, int CtRun, int RecordNum,  BackgroundWorker BGWrkr)
        {
            
            Int64 StartSector, EndSector;
            Int64 RecStartLoc, RecEndLoc, PacketSize;
            UInt32 RecFirstLoc, RecLastLoc;
            Int64 i;

            byte[] FileBuf, TempByteArray;

            
            //Initialize Variables
            RecStartLoc = (Int64) SkeletonData[CtRun, RecordNum, 0];
            RecEndLoc = (Int64) SkeletonData[CtRun, RecordNum, 1];
            PacketSize = (ToolParamsInst.NoArms * 2) + 12;
            DownloadStat = 0;
            ProgressPrcnt = 0;
            CancelPrcs = false;

            //----------------------------------
            //Calculate StartSector
            //----------------------------------
            if (RecStartLoc >= 150)
            {
                StartSector = (((RecStartLoc - 150) * PacketSize) / 512) + ToolParamsInst.RunBeginSector;
                RecFirstLoc = (UInt32)RecStartLoc - 150;
            }
            else
            {
                StartSector = ToolParamsInst.RunBeginSector;
                RecFirstLoc = 0;
            }
            //----------------------------------
            //Calculate EndSector
            //----------------------------------
            if (RecEndLoc <= (ToolParamsInst.LastSampleCt - 150)) 
            {
                EndSector = (((RecEndLoc + 150) * PacketSize) / 512) + ToolParamsInst.RunBeginSector;
                RecLastLoc = (UInt32) RecEndLoc + 150;
            }
            else
            {
                EndSector = ((ToolParamsInst.LastSampleCt * PacketSize) / 512) + ToolParamsInst.RunBeginSector;
                RecLastLoc =  (UInt32) ToolParamsInst.LastSampleCt;
            }

            //Allocate Buffer
            FileBuf = new byte[ ((EndSector - StartSector) * 512) + 4];
            TempByteArray = new byte[513];

            TempByteArray = BitConverter.GetBytes(RecFirstLoc);

            //Write First RecFirstLoc to File Buf
            Array.Copy(TempByteArray, 0, FileBuf, 0, 4);

            bool ExitFlag;
            //----------------------------------
            //Start Reading data from the Sectors
            //----------------------------------
            for (i = StartSector; i < EndSector; i++)
            {
                ExitFlag = false;
                while ( (CancelPrcs == false ) && (ExitFlag == false))
                {
                    TempByteArray = Program.MainInst.ReadSectorFromTool((UInt32)i, true);
                    if (TempByteArray[0] == 3) DownloadStat = TempByteArray[0] * 256;
                    else if (TempByteArray[0] == 2)
                    {
                        DownloadStat = TempByteArray[0] * 256;
                        return DownloadStat;
                    }
                    else
                    {
                        DownloadStat = TempByteArray[0] * 256;
                        ExitFlag = true;
                        //Copy to File Buf
                        Array.Copy(TempByteArray, 1, FileBuf, (((i - StartSector) * 512) + 4), 512);
                        //Update Progress
                        ProgressPrcnt = EndSector - StartSector;
                        ProgressPrcnt = ((double) (i- StartSector) / ProgressPrcnt) * 100;
                        BGWrkr.ReportProgress((int)ProgressPrcnt + DownloadStat);
                    }

                }

                if (CancelPrcs == true) i = EndSector + 2;
            }

            try
            {
                string DataFolderPath = Program.MainInst.RootDrive + Program.MainInst.JobNo + CtRun.ToString("00") + "\\bin";
                //Create Destination folder if it doesn't exist
                if (!(Directory.Exists(DataFolderPath)))
                    Directory.CreateDirectory(DataFolderPath);

                //Delete File if it exists
                FileStream DataFile = new FileStream(DataFolderPath + "\\" + RecordNum.ToString() + ".bin", FileMode.Create);

                //Write File Buffer to the File
                DataFile.Write(FileBuf, 0, (int)(((EndSector - StartSector) * 512) + 4));
                DataFile.Close();

            }
            catch
            {
                return 4;
            }

            return 1;
        }


        //---------------------------------
        //Find Packet Beginning and return offset
        //---------------------------------
        int FindNextPacketOffset(int i, byte[] DataBuf)
        {
            i++;
            try
            {
                while (!((DataBuf[i + 3] == 'k') && (DataBuf[i + 2] == 'c') && (DataBuf[i + 1] == 'a') && (DataBuf[i] == 'P')))
                {
                    i++;
                }
                return i;

            }
            catch
            {
                return 0;
            }

        }


        //---------------------------------
        //Process A Record
        //---------------------------------
        public int ProcessARecord(ViewRuns.LatestToolParams ToolParamsInst, double[, ,] SkeletonData, int CtRun, int RecordNum, BackgroundWorker BGWrkr)
        {
            //Return Values 4 - Buffer Overrun
            byte[] DataBuf;
            UInt32 RecStartLoc;
            uint i, j;
            int FirstPacketBeginOffset;
            int EstNoOfPackets;

            int PacketSize;

            //Parsed Ct Record Data Variables
            double[,] ArmData;
            UInt32[] SecondaryParam;
            double[] Orntn;

            //Initialize Return Value Class
            PrcsReturnValsInst = new PrcsReturnVals();
            PrcsReturnValsInst.XSctn = new double[24];
            PrcsReturnValsInst.SuccessVal = 1;

            BGWrkr.ReportProgress((int)100 + 256);

            try
            {
                //---------------------------------
                //Read Binary File
                //---------------------------------
                string DataFolderPath = Program.MainInst.RootDrive + Program.MainInst.JobNo + CtRun.ToString("00") + "\\bin";
                FileStream DataFile = new FileStream(DataFolderPath + "\\" + RecordNum.ToString() + ".bin", FileMode.Open);

                //Allocate DataBuf and read datafile
                DataBuf = new byte[DataFile.Length];
                DataFile.Read(DataBuf, 0, (int) DataFile.Length);
                DataFile.Close();

                //Parse RecStart Loc
                RecStartLoc = BitConverter.ToUInt32(DataBuf, 0);

                i = 4;
                //Find beginning of First Packet
                while (!((DataBuf[i + 3] == 'k') && (DataBuf[i + 2] == 'c') && (DataBuf[i + 1] == 'a') && (DataBuf[i] == 'P')))
                {
                    i++;
                }

                //Beginning Packet offset
                FirstPacketBeginOffset = (int) i;

                //Packet Size
                PacketSize = (ToolParamsInst.NoArms * 2) + 12;

                //Calculate Estimated Number of Packets in file
                EstNoOfPackets = (DataBuf.Length - FirstPacketBeginOffset) / PacketSize;
                EstNoOfPackets -= 3; //Safety Margin

                //Allocate Data Variables
                ArmData = new double[EstNoOfPackets + 200, ToolParamsInst.NoArms];
                SecondaryParam = new UInt32[EstNoOfPackets + 200];
                Orntn = new double[EstNoOfPackets + 200];

                int PacketBeginOffset, ExitFlag;
                PacketBeginOffset = FirstPacketBeginOffset - 4;
                //Parse and Load all data from file
                int[] SnsrVoltage = new int[ToolParamsInst.NoArms];
                ExitFlag = 1;
                i = 0;
                while(ExitFlag == 1)
                {
                    if(DataBuf.Length >= (PacketBeginOffset + (PacketSize * 2)))
                    {
                        PacketBeginOffset = FindNextPacketOffset((PacketBeginOffset), DataBuf);
                    }
                    else PacketBeginOffset = 0;

                    
                    if (PacketBeginOffset != 0)
                    {
                        //                    PacketBeginOffset = (int)(FirstPacketBeginOffset + (i * PacketSize));
                        //Extract Sensor Values for the Current Packet and Convert it to ArmOrder
                        for (j = 0; j < ToolParamsInst.NoArms; j++)
                        {
                            SnsrVoltage[ToolParamsInst.ArmOfChnl[j]] = (DataBuf[PacketBeginOffset + 4 + (j * 2)] << 8) + DataBuf[PacketBeginOffset + 4 + (j * 2) + 1];
                        }

                        //Convert Raw  volts to  normalized radial values
                        for (j = 0; j < ToolParamsInst.NoArms; j++)
                        {
                            ArmData[i, j] = SnsrVoltage[j];
                            ArmData[i, j] = (((ArmData[i, j] * 3.3) / 4096) * ToolParamsInst.CalibSlope[j]) + ToolParamsInst.YIntcpt[j];
                            ArmData[i, j] = (ArmData[i, j] * 0.9) / (double)(ToolParamsInst.ToolSize / 2);
                        }

                        //Extract Orientation
                        Orntn[i] = (double)((DataBuf[PacketBeginOffset + 4 + (ToolParamsInst.NoArms * 2)] << 8) + DataBuf[PacketBeginOffset + 4 + (ToolParamsInst.NoArms * 2) + 1]);
                        Orntn[i] *= 0.025;
                        Orntn[i] = 359.975 - Orntn[i];

                        //Extract Secondary Param
                        byte[] TmpByteArray = new byte[4];

                        for (j = 0; j < 4; j++) TmpByteArray[3 - j] = DataBuf[PacketBeginOffset + 4 + (ToolParamsInst.NoArms * 2) + 4 + j];

                        SecondaryParam[i] = BitConverter.ToUInt32(TmpByteArray, 0);
                        i++;
                    }
                    else ExitFlag = 0;
                }

                //------------------------
                //Loop Through trouble spot to mind the tightest spot
                //------------------------
                uint LocalPeakOdo, MinArm;
                LocalPeakOdo =  (uint) SkeletonData[CtRun, RecordNum, 0] - RecStartLoc;
                double MinVal = 100;
                MinArm = 0;
                for (i = (uint)(SkeletonData[CtRun, RecordNum, 0] - RecStartLoc); i < (uint) (SkeletonData[CtRun, RecordNum, 1] - RecStartLoc); i++)
                {
                    for (j = 0; j < ToolParamsInst.NoArms; j++)
                    {
                        if (MinVal > ArmData[i, j])
                        {
                            LocalPeakOdo = (uint) i;
                            MinArm = (uint) j;
                            MinVal = ArmData[i, j];
                        }
                    }
                }

                //

                //-----------------------
                //Find Time - ms ticks from launch
                //-----------------------
                if (ToolParamsInst.IsCtRunTimeBased > 0)
                {
                    //If the LocalPeakOdo + RecFirstLoc > LastTimeSampleCt - No Value 
                    if (((uint)LocalPeakOdo + RecStartLoc) < ToolParamsInst.LastPriIndex)
                    {
                        double msPeriod = ToolParamsInst.Frequency;
                        msPeriod = (1 / msPeriod) * 1000;
                        PrcsReturnValsInst.TimeOfEvent = LocalPeakOdo + RecStartLoc;
                        PrcsReturnValsInst.TimeOfEvent *= msPeriod;
                    }
                    else PrcsReturnValsInst.TimeOfEvent = 0;

                }
                else
                {
                    //Just append secondary Parameter
                    PrcsReturnValsInst.TimeOfEvent = SecondaryParam[LocalPeakOdo];
                    PrcsReturnValsInst.TimeOfEvent *= 100;
                }

                //--------------------------
                //Find Distance
                //---------------------------
                if (ToolParamsInst.IsCtRunTimeBased > 0)
                {
                    //If the LocalPeakOdo + RecFirstLoc > LastTimeSampleCt - 
                    if ((LocalPeakOdo + RecStartLoc) < ToolParamsInst.LastPriIndex)
                    {
                        PrcsReturnValsInst.DistanceOfEvent = SecondaryParam[LocalPeakOdo];
                        PrcsReturnValsInst.DistanceOfEvent = PrcsReturnValsInst.DistanceOfEvent / 48;
                    }
                    //Take LastOdoCt + (LastSampleCt - LastTimeSampleCt)
                    else
                    {
                        PrcsReturnValsInst.DistanceOfEvent = ToolParamsInst.LastSecIndex + (ToolParamsInst.LastSampleCt - ToolParamsInst.LastPriIndex);
                        PrcsReturnValsInst.DistanceOfEvent = PrcsReturnValsInst.DistanceOfEvent / 48;
                    }

                }
                else
                {
                    //Just append Primary parameter - Distance
                    PrcsReturnValsInst.DistanceOfEvent = LocalPeakOdo + RecStartLoc;
                    PrcsReturnValsInst.DistanceOfEvent = PrcsReturnValsInst.DistanceOfEvent / 48;
                }

                //Adjust Distance for Tool sizes 16 inch and above
                if (ToolParamsInst.ToolSize >= 16) PrcsReturnValsInst.DistanceOfEvent *= 2;

                //--------------------------
                //Find MinID
                //---------------------------
                uint MinOppArm = MinArm + ((uint) ToolParamsInst.NoArms / 2);
                if (MinOppArm >= ToolParamsInst.NoArms) MinOppArm = MinOppArm - (uint) ToolParamsInst.NoArms;
                PrcsReturnValsInst.MinID = ((ArmData[LocalPeakOdo, MinArm] + ArmData[LocalPeakOdo, MinOppArm]) * (ToolParamsInst.ToolSize/ 2))/0.9;

                //--------------------------
                //Find O'Clock
                //---------------------------
                double DegreesPerArm = 360 / (ToolParamsInst.NoArms);
                PrcsReturnValsInst.OClock = Orntn[LocalPeakOdo] + ((double) MinArm * DegreesPerArm);
                if (PrcsReturnValsInst.OClock >= 360) PrcsReturnValsInst.OClock -= 360;

                //--------------------------
                //Find Length
                //---------------------------
                if (ToolParamsInst.IsCtRunTimeBased > 0)
                {
                    //If CtRec is before the lasttimesamplect
                    if (SkeletonData[CtRun, RecordNum, 1] < ToolParamsInst.LastPriIndex)
                        PrcsReturnValsInst.Length = SecondaryParam[(uint)(SkeletonData[CtRun, RecordNum, 1] - RecStartLoc)] - SecondaryParam[(uint)(SkeletonData[CtRun, RecordNum, 0] - RecStartLoc)];
                    //If CtRec is after lasttimesamplect
                    else PrcsReturnValsInst.Length = SkeletonData[CtRun, RecordNum, 1] - SkeletonData[CtRun, RecordNum, 0];
                }
                else
                {
                    //Distance Based - Direct measurement from RecStartLoc and RecEndLoc
                    PrcsReturnValsInst.Length = SkeletonData[CtRun, RecordNum, 1] - SkeletonData[CtRun, RecordNum, 0];
                }

                if (ToolParamsInst.ToolSize >= 16) PrcsReturnValsInst.Length /= 24;
                else PrcsReturnValsInst.Length /= 48;

                //--------------------------
                //calculate Cross section
                //--------------------------

                //Extrapolate NoArms values at LocalPeakOdo to NoArms*6 points
                double[] TempXSctn = new double[ToolParamsInst.NoArms * 6];
                double XSctnStepDiff;
                for(i=0;i<ToolParamsInst.NoArms;i++)
                {
                    TempXSctn[(i * 6)] = ArmData[LocalPeakOdo, i];

                    if (i < (ToolParamsInst.NoArms - 1))
                        XSctnStepDiff = ArmData[LocalPeakOdo, i] - ArmData[LocalPeakOdo, (i + 1)];
                    else
                        XSctnStepDiff = ArmData[LocalPeakOdo, i] - ArmData[LocalPeakOdo, 0];
                    XSctnStepDiff /= 5;
                    //Find Extrapolated values
                    for (j = 1; j < 6; j++)
                    {
                        TempXSctn[(i * 6) + j] = TempXSctn[(i * 6)] - (XSctnStepDiff * j);
                    }
                }

                int XSctnStartPt;
                double XSctnPtStep;

                XSctnPtStep = (double)(ToolParamsInst.NoArms * 6) / (double)24;
                XSctnStartPt = (int) Orntn[LocalPeakOdo] / 15;
                for (i = 0; i < 24; i++)
                {
                    long TempXSctnLoadPt;
                    if((XSctnStartPt + i) >= 24) TempXSctnLoadPt = (XSctnStartPt + i) - 24;
                    else TempXSctnLoadPt = (XSctnStartPt + i);
                    double TempCtSrcPt;
                    TempCtSrcPt = XSctnPtStep * i;
                    PrcsReturnValsInst.XSctn[TempXSctnLoadPt] = TempXSctn[(int)TempCtSrcPt];
                }

            }
            catch
            {
                PrcsReturnValsInst.SuccessVal = 2;
            }

            return 1;
        }


    }
}
