﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Data.SQLite;
using System.IO;
using System.Runtime.InteropServices;
using System.Globalization;

namespace WindowsFormsApplication1
{
    public partial class CreateReport : Form
    {
        double WallThickness;
        string DataBasePath;

        public CreateReport()
        {
            InitializeComponent();
        }

 //       class PRViewerClass
 //       {
            [DllImport("prviewer.dll")]
            static public extern int OpenTemplate(string FileName);

            [DllImport("prviewer.dll")]
            static public extern int CloseTemplate();

            [DllImport("prviewer.dll")]
            static public extern int SetVariable(string VarName, string  Value);

            [DllImport("prviewer.dll")]
            static public extern int SetDatabase(String DatabaseName, String PropertyName, String PropertyValue);

            [DllImport("prviewer.dll")]
            static public extern int Preview();

            [DllImport("prviewer.dll")]
            static public extern int PrintDoc(string PrinterName);

   //     }

        private void GenReportBtn_Click(object sender, EventArgs e)
        {
            try
            {
                //Validate Wall Thickness
                WallThickness = Convert.ToDouble(WallThicknessTextBox.Text);
            }
            catch
            {
                MessageBox.Show("Invalid Wall Thickness Value", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }

            //If metric, convert to imperial
            if (Program.MainInst.IsImperialPref == 0) WallThickness *= 0.0393700787;

            CreateDataBase();

        }

        //-------------------------------------------------------------
        //Create Database
        //-------------------------------------------------------------
        private int CreateDataBase()
        {
            try
            {
                //Create or Overwrite Database file 
                FileStream FileStreamInst = File.Create(DataBasePath);
                FileStreamInst.Close();

                SQLiteConnection DBConn1;

                DBConn1 = new SQLiteConnection("Data Source=" + DataBasePath);
                DBConn1.Open();
                SQLiteCommand Cmd = DBConn1.CreateCommand();
                Cmd.CommandType = CommandType.Text;

                //Create Data Table
                Cmd.CommandText = "CREATE TABLE data (ID INTEGER PRIMARY KEY NULL, DateTime TEXT, Distance REAL, Feature TEXT(20), Orientation TEXT,";
                Cmd.CommandText += "JointLength REAL, USM REAL, DSM REAL, USW REAL, DSW REAL, Cross_Sec REAL, Percent REAL, Depth REAL, Length REAL, Width REAL,";
                Cmd.CommandText += "Station TEXT, Comment TEXT)";
                Cmd.ExecuteNonQuery();

                //Create Info Table
                Cmd.CommandText = "CREATE TABLE info ( serialno TEXT, jobno TEXT, client TEXT, city TEXT, state TEXT, country TEXT, size TEXT,";
                Cmd.CommandText += "rdate TEXT, qc TEXT, qcdate TEXT, section TEXT, launch TEXT, trap TEXT, wall TEXT, runprod TEXT, channels INTEGER,";
                Cmd.CommandText += " launch_time TEXT, trap_time TEXT, trap_date TEXT, setting TEXT, end_data TEXT, isfreq TEXT, runfreq TEXT, time_zone TEXT)";
                Cmd.ExecuteNonQuery();
                
                //Create plots
                Cmd.CommandText = "CREATE TABLE plots ( distance REAL, plot TEXT, section TEXT)";
                Cmd.ExecuteNonQuery();

                //Create speed
                Cmd.CommandText = "CREATE TABLE speed ( distance REAL, speed REAL)";
                Cmd.ExecuteNonQuery();

                float ToolSize;
                int NoArms;
                int CtRunNumLoc;
                ToolSize = Program.MainInst.ToolSize;
                NoArms = Program.MainInst.NoArms;
                CtRunNumLoc = Program.MainInst.ViewRunsInst.CtRunNum;

                //Now Insert into Info Table
                Cmd.CommandText = "INSERT INTO info VALUES ('', '" + Program.MainInst.JobNo + CtRunNumLoc.ToString("00") + "', '" + Program.MainInst.CompName + "', '" + Program.MainInst.City + "', '";
                Cmd.CommandText += Program.MainInst.State + "', '" +  Program.MainInst.Country + "', '" + ToolSize.ToString() + "', '" + LaunchdateTimePicker.Value.ToString("MMM dd yyyy") + "', '";
                Cmd.CommandText += Program.MainInst.QC + "', '" + Program.MainInst.QCDate + "', '" + SectionNameTxtBox.Text + "', '" + LaunchNameTxtBox.Text + "', '" + TrapNameTxtBox.Text + "', '";
                Cmd.CommandText += WallThickness.ToString("0.000") + "', '" + RunProdTextBox.Text + "', '" + NoArms.ToString() + "', '" + LaunchdateTimePicker.Value.ToString("HH:mm") + "', '";
                Cmd.CommandText += TrapdateTimePicker.Value.ToString("HH:mm") + "', '" + TrapdateTimePicker.Value.ToString("MMM dd yyyy") + "', '" + ((double) Program.MainInst.ViewRunsInst.ToolParamsInst[Program.MainInst.ViewRunsInst.CtRunNum].Threshold / (double)1000000).ToString("0.00") + "', '";
                if (Program.MainInst.ViewRunsInst.ToolParamsInst[Program.MainInst.ViewRunsInst.CtRunNum].IsCtRunTimeBased > 0)
                {
                    Cmd.CommandText += (((double)Program.MainInst.ViewRunsInst.ToolParamsInst[Program.MainInst.ViewRunsInst.CtRunNum].LastSecIndex) / 48).ToString("0.00") + "', '";
                    Cmd.CommandText += "1', '" + Program.MainInst.ViewRunsInst.ToolParamsInst[Program.MainInst.ViewRunsInst.CtRunNum].Frequency.ToString("0") + "', ''";
                }
                else
                {
                    Cmd.CommandText += (((double)Program.MainInst.ViewRunsInst.ToolParamsInst[Program.MainInst.ViewRunsInst.CtRunNum].LastSampleCt) / 48).ToString("0.00") + "', '";
                    Cmd.CommandText += "0', '', ''";
                }
                Cmd.CommandText += ")";
                Cmd.ExecuteNonQuery();

                //Now Insert data fields into table
                int i;

                for (i = 0; i < Program.MainInst.ViewRunsInst.RecCtinRun[Program.MainInst.ViewRunsInst.CtRunNum]; i++)
                {
                    if (Program.MainInst.ViewRunsInst.SkeletonData[Program.MainInst.ViewRunsInst.CtRunNum, i, 8] == 1)
                    {
                        //Check to see if CtRecord is completely downloaded
                        Cmd.CommandText = "INSERT INTO data (ID, DateTime, Distance, Feature, Orientation, Cross_Sec, Length) VALUES (" + i.ToString() + ", '" + Program.MainInst.ViewRunsInst.CtRunTableValsInst[i].Time + "', '";
                        Cmd.CommandText += Program.MainInst.ViewRunsInst.CtRunTableValsInst[i].Distance + "', 'Dent', '" + Program.MainInst.ViewRunsInst.CtRunTableValsInst[i].OClock + "', '";
                        Cmd.CommandText += Program.MainInst.ViewRunsInst.CtRunTableValsInst[i].XSctn + "', '" + Program.MainInst.ViewRunsInst.CtRunTableValsInst[i].Length + "')";
                    }
                    else
                    {
                        //Check to see if CtRecord is completely downloaded
                        Cmd.CommandText = "INSERT INTO data (ID, DateTime, Distance, Feature, Comment) VALUES (" + i.ToString() + ", '" + Program.MainInst.ViewRunsInst.CtRunTableValsInst[i].Time + "', '";
                        Cmd.CommandText += Program.MainInst.ViewRunsInst.CtRunTableValsInst[i].Distance + "', 'Dent', 'Record Not Downloaded')";
                    }
                    Cmd.ExecuteNonQuery();
                }
                

                Cmd.Dispose();
                DBConn1.Close();

                if (Program.MainInst.IsImperialPref == 1) OpenTemplate("GNGSUMimp.pr");
                else OpenTemplate("GNGSUMmet.pr");
                SetDatabase("db1", "DatabaseName", DataBasePath);
                SetDatabase("db2", "DatabaseName", DataBasePath);
                SetDatabase("db3", "DatabaseName", DataBasePath);

                Preview();
                CloseTemplate();

            }
            catch
            {
            }



            return 0;
        }



        private void CreateReport_Load(object sender, EventArgs e)
        {
            if (Program.MainInst.IsImperialPref == 1) WTUnitLbl.Text = "inch";
            else WTUnitLbl.Text = "mm";

            //Populate Datetimepicker
            LaunchdateTimePicker.Value =  DateTime.Now;
            TrapdateTimePicker.Value = DateTime.Now;

            int TempInt;

            TempInt = Program.MainInst.ViewRunsInst.CtRunNum;

            //DatabasePath Prep
            DataBasePath = Program.MainInst.RootDrive + Program.MainInst.JobNo + TempInt.ToString("00");
            DataBasePath += "\\" + Program.MainInst.JobNo + TempInt.ToString("00") + ".db";

            LoadGUIfields();

            //Check to see if Database already exists
            //if does, read the info file and populate the fields

        }

        private void LoadGUIfields()
        {
            if (File.Exists(DataBasePath))
            {
                SQLiteConnection DBConn1;
                DBConn1 = new SQLiteConnection("Data Source=" + DataBasePath);
                try
                {
                    DBConn1.Open();

                    string selectSQL = "SELECT * FROM info";

                    SQLiteCommand Cmd = new SQLiteCommand(selectSQL, DBConn1);
                    SQLiteDataReader dataReader = Cmd.ExecuteReader();

                    dataReader.Read();

                    SectionNameTxtBox.Text = dataReader.GetString(10);
                    LaunchNameTxtBox.Text = dataReader.GetString(11);
                    TrapNameTxtBox.Text = dataReader.GetString(12);
                    RunProdTextBox.Text = dataReader.GetString(14);
                    WallThicknessTextBox.Text = dataReader.GetString(13);

                    string LaunchDateTime = dataReader.GetString(7) + " " + dataReader.GetString(16);
                    string TrapDateTime = dataReader.GetString(18) + " " + dataReader.GetString(17);

                    DateTime DateTimeVal = new DateTime();
                    CultureInfo provider = CultureInfo.InvariantCulture;
                    string format = "MMM dd yyyy HH:mm";

                    DateTimeVal = DateTime.ParseExact(LaunchDateTime, format, provider);
                    LaunchdateTimePicker.Value = DateTimeVal;

                    DateTimeVal = DateTime.ParseExact(TrapDateTime, format, provider);
                    TrapdateTimePicker.Value = DateTimeVal;
                    Cmd.Dispose();
                    dataReader.Close();
                    DBConn1.Close();
                }
                catch
                {
                    if (DBConn1 != null) DBConn1.Close();
                }
            }

            
        }

    }
}
