﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;


namespace WindowsFormsApplication1
{
    public partial class Launch : Form
    {
        bool LaunchResult;
        bool BgWrkrReqCancel;
        public Launch()
        {
            InitializeComponent();
        }

        private void Launch_Load(object sender, EventArgs e)
        {
            SetDefaultRadioBtns();
            Program.MainInst.ReadConfigFile();
            if (Program.MainInst.AdminMode == 0)
            {
                SetLaunchingModeGUI();
            }
            else
            {
                SetSelectionModeGUI();
            }
            LaunchResult = false;
            BgWrkrReqCancel = false;
        }

        private void SetDefaultsBtn_Click(object sender, EventArgs e)
        {
            SetDefaultRadioBtns();
        }

        //------------------------------------
        //Default Radio button States
        //------------------------------------
        private void SetDefaultRadioBtns()
        {
            FrequencyRadio.Checked = true;
            SlowSpeedRadio.Checked = true;
            ContinousRadio.Checked = true;
        }

        private void SetSelectionModeGUI()
        {
            LaunchLbl.Visible = true;
            LaunchModeGrp.Visible = true;
            SpdGrpBox.Visible = true;
            XtergroupBox.Visible = true;
            LaunchBtn.Visible = true;
            SetDefaultsBtn.Visible = true;
            BacktoMMBtn.Visible = true;
            LaunchignToolLbl.Visible = false;
            LaunchingToolPrgrsbar.Visible = false;
        }

        private void SetLaunchingModeGUI()
        {
            LaunchLbl.Visible = false;
            LaunchModeGrp.Visible = false;
            SpdGrpBox.Visible = false;
            XtergroupBox.Visible = false;
            LaunchBtn.Visible = false;
            SetDefaultsBtn.Visible = false;
            BacktoMMBtn.Visible = false;
            LaunchignToolLbl.Visible = true;
            LaunchingToolPrgrsbar.Visible = true;
            //Launch BGWrkr
            BGWrkr.RunWorkerAsync();
        }

        private void BGWrkr_DoWork(object sender, DoWorkEventArgs e)
        {
            //Test Read Sector
            byte[] ReadData = new byte[513];
            byte[] FreqBytes = new byte[4];

            //----------------------------
            //Write Frequency to Sector
            //----------------------------
            ReadData = Program.MainInst.ReadSectorFromTool(11, false);
            if (ReadData[0] != 1) return;
            
            //Calculate Frequency Bytes
            if (SlowSpeedRadio.Checked == true) FreqBytes = BitConverter.GetBytes(1056);
            else FreqBytes = BitConverter.GetBytes(2112);
            ReadData[5] = FreqBytes[3];
            ReadData[6] = FreqBytes[2];
            ReadData[7] = FreqBytes[1];
            ReadData[8] = FreqBytes[0];

            if (Program.MainInst.WriteSectorToTool(11, ReadData, 1, false) != 1) return;

            //Write Transmitter Mode
            ReadData = Program.MainInst.ReadSectorFromTool(0, false);
            if (ReadData[0] != 1) return;
            if (ContinousRadio.Checked == true) ReadData[16] = 1;
            else ReadData[16] = 0;
            if (Program.MainInst.WriteSectorToTool(0, ReadData, 1, false) != 1) return;

            //Issue Launch Command
            if (DistanceRadio.Checked == true)
            {
                if (Program.MainInst.SendSingleCmdCmpr((byte)'l', 4, Encoding.ASCII.GetBytes("Done"), false) != 1) return;
            }
            else
            {
                if (Program.MainInst.SendSingleCmdCmpr((byte)'t', 4, Encoding.ASCII.GetBytes("Done"), false) != 1) return;
            }

            LaunchResult = true;
        }

        private void BGWrkr_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            bool LocalPrcsSuccess = false;

            if (BgWrkrReqCancel == false)
            {
                LaunchingToolPrgrsbar.Value = 100;

                try
                {
                    string RunNumDir;

                    //Write To the Config file
                    Program.MainInst.ReadConfigFile();
                    Program.MainInst.CtRunNum++;
                    Program.MainInst.IsToolLaunched = 1;
                    Program.MainInst.WriteConfigFile();

                    int TmpInt;
                    TmpInt = Program.MainInst.CtRunNum;

                    RunNumDir = Program.MainInst.RootDrive + Program.MainInst.JobNo + TmpInt.ToString("00");
                    //Create RunNum Directory
                    if (Directory.Exists(RunNumDir) == false)
                        Directory.CreateDirectory(RunNumDir);
                    //Create TimeStamp file

                    string DateTimeString;
                    DateTimeString = DateTime.Now.ToString("MM/dd/yyyy HH:mm:ss.fff");
                    //Write the Current date and Time
                    FileStream TempFilePtr;
                    TempFilePtr = File.Open(RunNumDir + "\\" + "ts.bin", FileMode.Create);
                    TempFilePtr.Write(Encoding.ASCII.GetBytes(DateTimeString), 0, DateTimeString.Length);
                    TempFilePtr.Close();

                    LocalPrcsSuccess = true;

                }
                catch
                {
                    LaunchignToolLbl.ForeColor = Color.Red;
                    LaunchignToolLbl.Text = "ERROR : Config Files Not Updated - Tool Successfully Launched - Contact EnviroCal";

                }

                if (LocalPrcsSuccess == true)
                {
                    if (LaunchResult == true)
                    {
                        LaunchignToolLbl.Text = "Tool Launched";
                        LaunchingToolPrgrsbar.Style = ProgressBarStyle.Blocks;
                    }
                    else
                    {
                        LaunchignToolLbl.ForeColor = Color.Red;
                        LaunchignToolLbl.Text = "ERROR : Tool NOT Launched";

                    }
                    //If Admin mode is selected, release the admin mode
                    if (Program.MainInst.AdminMode == 1)
                    {
                        Program.MainInst.AdminMode = 0;
                        Program.MainInst.WriteConfigFile();
                    }
                }

                Tmr.Interval = 3000;
                Tmr.Enabled = true;
                Tmr.Start();
            }
            else
            {
                Program.MainInst.Show();
                this.Dispose();
            }
        }

        private void LaunchBtn_Click(object sender, EventArgs e)
        {
            SetLaunchingModeGUI();
        }

        private void Launch_FormClosed(object sender, FormClosedEventArgs e)
        {
            this.Dispose();
            Program.MainInst.Dispose();
            BGWrkr.Dispose();
            Application.Exit();
        }

        private void Tmr_Tick(object sender, EventArgs e)
        {
            Program.MainInst.Show();
            this.Dispose();
        }

        private void DistanceRadio_CheckedChanged(object sender, EventArgs e)
        {
            if (DistanceRadio.Checked == true)
                SpdGrpBox.Enabled = false;
            else SpdGrpBox.Enabled = true;
        }

        private void BacktoMMBtn_Click(object sender, EventArgs e)
        {
            if (BGWrkr.IsBusy == true)
            {
                BGWrkr.CancelAsync();
                BgWrkrReqCancel = true;
            }
            else
            {
                Program.MainInst.Show();
                this.Dispose();
            }
        }

    }
}
