﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO.Ports;
using System.Threading;
using System.IO;

namespace WindowsFormsApplication1
{
    public partial class EstablishingComm : Form
    {
        //------------------------------------
        //Global Variables
        //------------------------------------
        
        public int BattVal;
        string LocalComPortName;
        int LocalBattVal;
        bool CancellationRequested = false;

        bool DownloadBGWrkrSuccess, DownloadBGWrkrCancelled;

        //Local Variables used across threads
        int CtRunNum;

        int TotalRecordCount, CtRecCount;

        bool ProperShutdown = false;

        string DateTimeString;

        public EstablishingComm()
        {
            InitializeComponent();
        }

        private void EstablishingComm_Load(object sender, EventArgs e)
        {
            label1.ForeColor = Color.Green;
            label1.Text = "Establishing Communication";
            //Launch BGWrkr
            SerBGWrkr.RunWorkerAsync();
            PrgrsBar.Value = 20;
            PrgrsBar.Style = ProgressBarStyle.Marquee;
        }

        //----------------------------------------------------
        //Serial Background Worker Run Routine
        //----------------------------------------------------
        private void SerBGWrkr_DoWork(object sender, DoWorkEventArgs e)
        {
            SerialPort Serial = new SerialPort();
            Byte[] RetVal = new Byte[100];
            int i;

            //----------------------------------------
            //Get list of Serial Ports and Find out which one is our Zigbee
            //----------------------------------------
            string[] ports = SerialPort.GetPortNames();

            //Set Common Parameters for all Ports
            Serial.BaudRate = 57600;
            Serial.StopBits = StopBits.One;
            Serial.Parity = Parity.None;
            Serial.RtsEnable = false;
            Serial.ReadTimeout = 2000;
            bool FoundAPort = false;

            LocalComPortName = "None";
            foreach (string port in ports)
            {
                if (CancellationRequested == true) break;
                try
                {
                    
                    //Open that COM Port at 57600, 8bits, No Parity, No Flow control
                    Serial.PortName = port;
                    Serial.Open();
                    Serial.DiscardInBuffer();
                    int j;

                    for (j = 0; j < 4; j++)
                    {

                        Serial.Write("+++");
                        for (i = 0; i < 2; i++) Serial.Read(RetVal, i, 1);

                        if ((RetVal[0] == 'O') && (RetVal[1] == 'K'))
                        {
                            LocalComPortName = port;
                            FoundAPort = true;
                            Serial.Write("ATCN" + "\r");
                            Serial.Close();
                            j = 10;
                            break;
                        }
                    }
                    Serial.Close();

                }
                catch (TimeoutException)
                {
                    if (Serial.IsOpen == true) Serial.Close();
                    
                }
                catch
                {
                    if (Serial.IsOpen == true) Serial.Close();
                    
                }
                
            }
            //-----------------------------------------------

            if (FoundAPort == false) return;


            //Open that COM Port at 57600, 8bits, No Parity, No Flow control
            Serial.PortName = LocalComPortName;
            Serial.ReadTimeout = 100;
            LocalBattVal = 0;
            //-------------------------------------------------
            //Now send the Ping Cmd to the tool
            //-------------------------------------------------
            for (i = 0; i < 50; i++)
            {
                if (CancellationRequested == true) break;

                try
                {   
                    Serial.Open();
                    Serial.Write("p");

                    Serial.Read(RetVal, 0, 1);
                    LocalBattVal = RetVal[0];
                    Serial.Close();
                    break;
                }
                catch (TimeoutException)
                {
                    if (Serial.IsOpen == true) Serial.Close();
                }
                catch
                {
                    i = 300;
                    if (Serial.IsOpen == true) Serial.Close();
                }
            }
        }

        private void SerBGWrkr_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            PrgrsBar.Value = 100;
            PrgrsBar.Style = ProgressBarStyle.Blocks;

            if (CancellationRequested == false)
            {
                if (LocalComPortName == "None")
                {
                    label1.Text = "  Insert RSCaliper Dongle";
                    label1.ForeColor = Color.Red;
                    Tmr.Enabled = true;
                }
                else if (LocalBattVal == 0)
                {
                    label1.Text = "         Tool Not Found";
                    label1.ForeColor = Color.Red;
                    Tmr.Enabled = true;
                }
                else
                {
                    
                    Program.MainInst.ComPortName = LocalComPortName;
                    //Show Appropriate Screen
                    if (Program.MainInst.ModeRequested == "Launch")
                    {
                        Launch LaunchInst = new Launch();
                        LaunchInst.Show();
                        this.Dispose();
                        ProperShutdown = true;
                    }
                    else if (Program.MainInst.ModeRequested == "Download")
                    {
                        PrgrsBar.Value = 20;
                        PrgrsBar.Style = ProgressBarStyle.Marquee;
                        
                        //Copy Variables
                        CtRunNum = Program.MainInst.CtRunNum;

                        //Update Label
                        
                        label1.Text = "Extracting Go-NoGo Records";
                        
                        //Extract Important Download Information
                        DownloadInfoBGWrkr.RunWorkerAsync();

                    }
                    else if (Program.MainInst.ModeRequested == "Diagnostics")
                    {
                        Diagnostics DiagInst = new Diagnostics();
                        DiagInst.Show();
                        this.Dispose();
                        ProperShutdown = true;
                    }
                    
                }
            }
            else
            {
                this.Dispose();
                Program.MainInst.Show();
            }

        }

        private void Tmr_Tick(object sender, EventArgs e)
        {
            //Dispose this resource and Show Main
            ProperShutdown = true;
            Program.MainInst.Show();
            this.Dispose();
        }

        private void CancelBtn_Click(object sender, EventArgs e)
        {  
            if (SerBGWrkr.IsBusy == true)
            {
                SerBGWrkr.CancelAsync();
                CancellationRequested = true;
            }
            else if (DownloadInfoBGWrkr.IsBusy == true)
            {
                DownloadInfoBGWrkr.CancelAsync();
                DownloadBGWrkrCancelled = true;
            }
            else
            {
                Program.MainInst.Show();
                this.Dispose();
            }
        }


        private void EstablishingComm_FormClosed(object sender, FormClosedEventArgs e)
        {
            SerBGWrkr.Dispose();
            DownloadInfoBGWrkr.Dispose();
            this.Dispose();
            Program.MainInst.Dispose();

            Application.Exit();
        }



        private void DownloadInfoBGWrkr_DoWork(object sender, DoWorkEventArgs e)
        {
            //-----------------------------------------
            //Extract and Store Calibration Information
            //-----------------------------------------
            //Step1: Read Sector 


            byte[] ToolResponse = new byte[513];
            //Send Download Command
            ToolResponse = Program.MainInst.SendSingleCmd((byte)'d', 4, false);
            if (ToolResponse[0] != 1) return;

            if ((ToolResponse[1] != 'D') || (ToolResponse[2] != 'o') || (ToolResponse[3] != 'n') || (ToolResponse[4] != 'e'))
            {
                MessageBox.Show("Improper Download Response from Tool - Please Retry", "Error", MessageBoxButtons.OK, MessageBoxIcon.Stop);
                return;
            }

            FileStream TempFilePtr;
            //Find the latest Run Number, ToolSize, NoArms from tool and put it on Calib.txt
            //Create File and get skeletal GoNoGo
            string JobNoPath;
            JobNoPath = Program.MainInst.RootDrive + Program.MainInst.JobNo + CtRunNum.ToString("00");
            try
            {
                TempFilePtr = File.Create(JobNoPath + "\\Calib.bin");
                TempFilePtr.Close();

                TempFilePtr = File.Create(JobNoPath + "\\Skeleton.bin");
                TempFilePtr.Close();
                
                //Update TimeStamp File
                
                TextReader TempTxtRdr =  File.OpenText(JobNoPath + "\\ts.bin");
                DateTimeString = TempTxtRdr.ReadLine();
                TempTxtRdr.Close();
                
                //Write the Current date and Time -  Clear the last line to indicat that an active download has started
                TempFilePtr = File.Open(JobNoPath + "\\ts.bin", FileMode.Open);
                TempFilePtr.Write(Encoding.ASCII.GetBytes(DateTimeString), 0, DateTimeString.Length);
                TempFilePtr.Close();
                DateTimeString += "\n" + DateTime.Now.ToString("MM/dd/yyyy HH:mm:ss.fff");
            }
            catch
            {
                MessageBox.Show("Unable to Create Launch Files - Please Contact EnviroCal", "Error", MessageBoxButtons.OK, MessageBoxIcon.Stop);
                return;
            }

            //Start Preparing Calib text file
            string CalibTxt;
            int NoArms;

            CalibTxt = "";
            //Read Sector 1
            ToolResponse = Program.MainInst.ReadSectorFromTool(1, false);
            if (ToolResponse[0] != 1) return;
            NoArms = ToolResponse[8];
            CalibTxt = "NoArms:" + ToolResponse[8] + "\n";              //Line 0
            CalibTxt += "ToolSize:" + ToolResponse[12] + "\n";          //Line 1

            
            UInt32 Threshold;
            int LastRecCt;
            UInt32 RunBeginSector;

            ToolResponse = Program.MainInst.ReadSectorFromTool(0, false);
            if (ToolResponse[0] != 1) return;

            LastRecCt = (int) ConvertToUInt32(ToolResponse, 1);
            TotalRecordCount = LastRecCt;
            RunBeginSector = ConvertToUInt32(ToolResponse, 9);
            CalibTxt += "LastRecCt:" + ConvertToUInt32(ToolResponse, 1).ToString() + "\n";      //Line 2
            CalibTxt += "LastSampleCt:" + ConvertToUInt32(ToolResponse, 5).ToString() + "\n";   //Line 3
            CalibTxt += "RunBeginSector:" + ConvertToUInt32(ToolResponse, 9).ToString() + "\n"; //Line 4
            Threshold = ConvertToUInt32(ToolResponse, 25);
            
            ToolResponse = Program.MainInst.ReadSectorFromTool(8, false);
            if (ToolResponse[0] != 1) return;
            int CtRunNumTool;
            CtRunNumTool = ToolResponse[4];

            if (CtRunNumTool > 0) CtRunNumTool--;
            else
            {
                MessageBox.Show("No Run Exists in the tool", "Error", MessageBoxButtons.OK, MessageBoxIcon.Stop);
                return;
            }
            ToolResponse = Program.MainInst.ReadSectorFromTool(12, false);
            if (ToolResponse[0] != 1) return;

            CalibTxt += "Timebased?:" + ToolResponse[(CtRunNumTool*8) + 4].ToString() + "\n";            //Line 5
            CalibTxt += "LastPriIndex:" + ConvertToUInt32(ToolResponse, ((CtRunNumTool * 8) + 5)) + "\n";//Line 6
            
 
            ToolResponse = Program.MainInst.ReadSectorFromTool(13, false);
            if (ToolResponse[0] != 1) return;

            CalibTxt += "Frequency:" + ConvertToUInt32(ToolResponse, ((CtRunNumTool * 8) + 1)) + "\n";   //Line 7
            CalibTxt += "LastSecIndex:" + ConvertToUInt32(ToolResponse, ((CtRunNumTool * 8) + 5)) + "\n";//Line 8
            CalibTxt += "Threshold:" + Threshold.ToString() + "\n";                                   //Line 9

            int i, j;
            //Load ArmOfChnl Data
            ToolResponse = Program.MainInst.ReadSectorFromTool(1, false);
            if (ToolResponse[0] != 1) return;
            for (i = 0; i < NoArms; i++) CalibTxt += "ArmOfChnl" + i.ToString() + ":" + (ToolResponse[16 + (4*i)] - 1).ToString() + "\n";
            //Load Slope
            ToolResponse = Program.MainInst.ReadSectorFromTool(2, false);
            if (ToolResponse[0] != 1) return;
            byte[] TmpSnglByte = new byte[4];

            for (i = 0; i < NoArms; i++)
            {
                //Change Endianess and store it to temp
                for (j = 0; j < 4; j++) TmpSnglByte[3 - j] = ToolResponse[(4*i) + 1 + j];
                //Store it to Single and Load it to the Output string
                CalibTxt += "SlopeofArm" + i.ToString() + ":" + (BitConverter.ToSingle(TmpSnglByte, 0).ToString("0.###")) + "\n";
            }

            //Load YIntcpt
            ToolResponse = Program.MainInst.ReadSectorFromTool(3, false);
            if (ToolResponse[0] != 1) return;
            
            for (i = 0; i < NoArms; i++)
            {
                //Change Endianess and store it to temp
                for (j = 0; j < 4; j++) TmpSnglByte[3 - j] = ToolResponse[(4 * i) + 1 + j];
                //Store it to Single and Load it to the Output string
                CalibTxt += "YIntcptofArm" + i.ToString() + ":" + (BitConverter.ToSingle(TmpSnglByte, 0).ToString("0.###")) + "\n";
            }

            try
            {
                TempFilePtr = File.Open(JobNoPath + "\\Calib.bin", FileMode.Open);
                TempFilePtr.Write(Encoding.ASCII.GetBytes(CalibTxt), 0, CalibTxt.Length);
                TempFilePtr.Close();
            }
            catch
            {
                MessageBox.Show("Unable to Write Launch Files - Please Contact EnviroCal", "Error", MessageBoxButtons.OK, MessageBoxIcon.Stop);
                return;
            }


            //--------------------------------
            //Populate Skeleton Table
            //--------------------------------
            int SecsToRead;
            SecsToRead = (int) Math.Ceiling( (double) LastRecCt / 64);

            Int64[] RecStartLocs = new Int64[LastRecCt + 128];
            Int64[] RecEndLocs = new Int64[LastRecCt + 128 ];

            for (i = 0; i < SecsToRead; i++)
            {
                ToolResponse = Program.MainInst.ReadSectorFromTool( (16 + i), false);
                if (ToolResponse[0] != 1) return;
                for (j = 0; j < 64; j++)
                {
                    RecStartLocs[(i * 64) + j] = ConvertToUInt32(ToolResponse, ((j * 8) + 1));
                    RecEndLocs[(i * 64) + j] = ConvertToUInt32(ToolResponse, ((j * 8) + 4 + 1));
                }
            }
            
            //----------------------------------
            //Get Seconday Data from the Tool Dataset
            //----------------------------------
            CalibTxt = "";
            CalibTxt = "RecStartLoc,RecEndLoc,SecValue,Time,Distance,MinIN,Length,DownloadStat";
            for(i=0;i<LastRecCt;i++)
            {
                CtRecCount = i + 1;
                DownloadInfoBGWrkr.ReportProgress(10);
                Int64 RetVal = GetSecParam(RecStartLocs[i], RecEndLocs[i], RunBeginSector, NoArms);
                if (RetVal == -1) return;
                else if (RetVal == -2)
                {
                    MessageBox.Show("Unable to Create Records Table. Please Try again.", "Error", MessageBoxButtons.OK, MessageBoxIcon.Stop);
                    return;
                }
                else CalibTxt += RecStartLocs[i].ToString() + "," + RecEndLocs[i].ToString() + "," + RetVal.ToString() + ",0,0,0,0,0\n";
            }


            try
            {
                TempFilePtr = File.Open(JobNoPath + "\\Skeleton.bin", FileMode.Open);
                TempFilePtr.Write(Encoding.ASCII.GetBytes(CalibTxt), 0, CalibTxt.Length);
                TempFilePtr.Close();

                //Write the Current date and Time - To indicate that the active skeleton download is done
                TempFilePtr = File.Open(JobNoPath + "\\ts.bin", FileMode.Open);
                TempFilePtr.Write(Encoding.ASCII.GetBytes(DateTimeString), 0, DateTimeString.Length);
                TempFilePtr.Close();
            }
            catch
            {
                MessageBox.Show("Unable to Write Launch Files - Please Contact EnviroCal", "Error", MessageBoxButtons.OK, MessageBoxIcon.Stop);
                return;
            }

            DownloadBGWrkrSuccess = true;


        }

        private void DownloadInfoBGWrkr_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            if (DownloadBGWrkrCancelled == false)
            {
                if (DownloadBGWrkrSuccess == true)
                {
                    Program.MainInst.Show();
                    this.Dispose();
                }
                else
                {
                    Program.MainInst.Show();
                    this.Dispose();
                }
            }
            else
            {
                Program.MainInst.Show();
                this.Dispose();
            }

        }

        //GetSecondary Parameter for a given record
        Int64 GetSecParam(Int64 RecStartLoc, Int64 RecEndLoc, Int64 RunBeginSector, int NoArms)
        {
            //Calculate Start Sector
            Int64 StartSector = ((RecStartLoc * ((NoArms * 2) + 12)) / 512) + RunBeginSector;
            Int64 StartReadingLocation = (RecStartLoc * ((NoArms * 2) + 12)) - ((StartSector - RunBeginSector) * 512);

            byte[] ToolResponse = new byte[513];
            byte[] ToolData = new byte[1026];
            ToolResponse = Program.MainInst.ReadSectorFromTool((int) StartSector, false);
            if (ToolResponse[0] != 1) return -1;

            Array.Copy(ToolResponse, 1, ToolData, 0, 512);
            ToolResponse = Program.MainInst.ReadSectorFromTool((int)(StartSector + 1), false);
            if (ToolResponse[0] != 1) return -1;

            Array.Copy(ToolResponse, 1, ToolData, 512, 512);

            bool ExitFlag = false;
            int SearchIndex = 0;
            while (ExitFlag == false)
            {
                if (ToolData[StartReadingLocation + SearchIndex] == 'P' &&
                    ToolData[StartReadingLocation + SearchIndex + 1] == 'a' &&
                    ToolData[StartReadingLocation + SearchIndex + 2] == 'c' &&
                    ToolData[StartReadingLocation + SearchIndex + 3] == 'k')
                {
                    ExitFlag = true;
                    return ConvertToUInt32(ToolData, (int)StartReadingLocation + 4 + (NoArms * 2) + 4);
                }
                else if ((StartReadingLocation + SearchIndex) < 950) SearchIndex++;
                else return -2;
            }
            
            return 0;
        }

        //Change Byte Order and return Uint32
        private UInt32 ConvertToUInt32(byte[] Data, int StartOffset)
        {
            byte[] TmpByte = new byte[4];
            int i;

            for (i = 0; i < 4; i++)
            {
                TmpByte[3 - i] = Data[StartOffset + i];
            }

            return BitConverter.ToUInt32(TmpByte, 0);
        }

        private void DownloadInfoBGWrkr_ProgressChanged(object sender, ProgressChangedEventArgs e)
        {
            System.Drawing.Point NewLoc = new System.Drawing.Point();
            NewLoc.X = PrgrsBar.Location.X;
            NewLoc.Y = 80;
            PrgrsBar.Location = NewLoc;
            label2.Visible = true;
            label2.Text = "Record " + CtRecCount.ToString() + " of " + TotalRecordCount.ToString();
        }



    }
}
