﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace WindowsFormsApplication1
{
    public partial class Diagnostics : Form
    {
        int NoArms, ToolSize;
        bool InitBGWrkrCancelReq, InitBGWrkrSuccess;
        bool PollingBGWrkrCancelReq, PollingBGWrkrSuccess;
        double CtThreshold, NewThreshold;
        byte BattVoltageNum;
        bool IsSnsrChkON;
        double[] SensorData;
        int CtMaxIndex;
        double[,] GraphBufer;
        bool NewSnsrDataAvl;

        bool BackToMMReq;
        public Diagnostics()
        {
            InitializeComponent();
        }

        private void Diagnostics_Load(object sender, EventArgs e)
        {
            InitLoadBgWrkr.RunWorkerAsync();
            InitLoadPrgrsBar.Value = 40;
            InitBGWrkrSuccess = false;
            IsSnsrChkON = false;

            InitLoadPrgrsBar.Visible = true;

            BattGrpBox.Visible = false;
            ThrshldLbl.Visible = false;
            OdoBox.Visible = false;
            OrntnBox.Visible = false;
            SnsrPlot.Visible = false; 
            NewThrshldTxtBox.Visible = false;
            LoadThrshld.Visible = false;
            CheckSnsrBtn.Visible = false;
            OdoLbl.Visible = false;
            BacktoMMBtn.Visible = false;
            BackToMMReq = false;
        }

        private void InitLoadBgWrkr_DoWork(object sender, DoWorkEventArgs e)
        {
            byte[] Data = new byte[513];
            int i;
            byte[] SingleTempByteArray = new byte[4];
            byte[] VoltageNumbers = new byte[15];

            // Read Sector 1
            Data = Program.MainInst.ReadSectorFromTool(1, false) ;
            if (Data[0] != 1) return;

            NoArms = Data[8];
            ToolSize = Data[12];
            //Read Sector 0
            Data = Program.MainInst.ReadSectorFromTool(0, false);
            if (Data[0] != 1) return;
            for (i = 0; i < 4; i++) SingleTempByteArray[3 - i] = Data[i+25];
            CtThreshold =  BitConverter.ToInt32(SingleTempByteArray, 0);
            CtThreshold /= 1000000;
            //Read BattVoltage Number

            for (i = 0; i < 15; i++)
            {
                Data = (Program.MainInst.SendSingleCmd((byte)'p', 1, false));
                if (Data[0] != 1) return;
                VoltageNumbers[i] = Data[1];
            }

            int Avg = 0;
            for (i = 0; i < 15; i++)
            {
                Avg += VoltageNumbers[i];
            }
            Avg = Avg/15;
            BattVoltageNum = (byte)Avg;

            InitBGWrkrSuccess = true;
        }

        private void InitLoadBgWrkr_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            if ((InitBGWrkrSuccess == true) && (InitBGWrkrCancelReq == false))
            {
                //Update Threshold Label
                ThrshldLbl.Text = "Current Threshold: " + CtThreshold.ToString("0.##");
                //Update Battery Labels
                BattRemLbl.Text = "Battery Remaining: " + BattVoltageNum.ToString();
                RunTimeLeftLbl.Text = "Run Time Remaining: ";
                InitLoadPrgrsBar.Style = ProgressBarStyle.Blocks;
                InitLoadPrgrsBar.Value = 0;
                SensorData = new double[NoArms + 3];
                GraphBufer = new double[200, NoArms];
                DisableInitGUI();
            }
            else
            {
                Program.MainInst.Show();
                this.Dispose();
            }
        }

        private void Diagnostics_FormClosed(object sender, FormClosedEventArgs e)
        {
            this.Dispose();
            PollingBGWrkr.Dispose();
            InitLoadBgWrkr.Dispose();
            Program.MainInst.Dispose();
            Application.Exit();
        }

        private void PollingBGWrkr_DoWork(object sender, DoWorkEventArgs e)
        {
            
            while (PollingBGWrkrCancelReq == false)
            {
                SensorData = Program.MainInst.ExtractSensorPacket(NoArms, false);
                if (SensorData[0] != 1) return;
                NewSnsrDataAvl = true;
            }
            PollingBGWrkrSuccess = true;
            
        }

        private void PollingBGWrkr_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            IsSnsrChkON = false;
            CheckSnsrBtn.Text = "Turn ON Sensor Check";
            PollingBGWrkrCancelReq = false;
            EventTmr.Enabled = false;
            this.Cursor = Cursors.Default;
            if (BackToMMReq == true)
            {
                Program.MainInst.Show();
                   this.Dispose();
            }
            //Clear Charts and Picture Boxes
            if (PollingBGWrkrSuccess == false)
            {
                
            }
            else
            {
            }
        }

        private void LoadThrshld_Click(object sender, EventArgs e)
        {
            double NewThreshold;
            //Validate NewThrshldTxtBox Input
            try
            {
                NewThreshold = Convert.ToDouble(NewThrshldTxtBox.Text);
            }
            catch
            {
                MessageBox.Show("Number not in valid format. Please check the Threshold value entered.", "Error", MessageBoxButtons.OK, MessageBoxIcon.Stop);
                return;
            }

            if ((NewThreshold > ToolSize) || (NewThreshold < (ToolSize / 2)))
            {
                MessageBox.Show("Threshold Value out of Range. Please enter a reasonable threshold number", "Error", MessageBoxButtons.OK, MessageBoxIcon.Stop);
                return;
            }

            //Write Threshold Value to the tool
            NewThreshold *= 1000000;
            UInt32 NewThresholdInt = (UInt32) NewThreshold;

            //Read Sector 0
            byte[] ToolData = new byte[513];
            ToolData = Program.MainInst.ReadSectorFromTool(0, false);
            if (ToolData[0] != 1) return;

            //Load New Threshold
            byte[] TempByte = new byte[4];
            TempByte = BitConverter.GetBytes(NewThresholdInt);

            //Append to ToolData
            ToolData[25] = TempByte[3];
            ToolData[26] = TempByte[2];
            ToolData[27] = TempByte[1];
            ToolData[28] = TempByte[0];

            //Read Sector back to tool
            if (Program.MainInst.WriteSectorToTool(0, ToolData, 1, false) != 1) return;

            MessageBox.Show("Threshold Successfully Loaded", "Error", MessageBoxButtons.OK, MessageBoxIcon.Asterisk);
            CtThreshold = NewThreshold / 1000000;
            ThrshldLbl.Text = "Current Threshold: " + CtThreshold.ToString("0.##");
            Program.MainInst.AdminMode = 0;
            Program.MainInst.WriteConfigFile();
            NewThrshldTxtBox.Visible = false;
            LoadThrshld.Visible = false;
        }

        private void CheckSnsrBtn_Click(object sender, EventArgs e)
        {
            if (IsSnsrChkON == false)
            {
                PollingBGWrkrCancelReq = false;
                PollingBGWrkr.RunWorkerAsync();
                IsSnsrChkON = true;
                CheckSnsrBtn.Text = "Turn OFF Sensor Check";
                EventTmr.Enabled = true;
            }
            else
            {

                if ((PollingBGWrkrCancelReq == false) && (PollingBGWrkr.IsBusy == true))
                {
                    PollingBGWrkr.CancelAsync();
                    this.Cursor = Cursors.WaitCursor;
                    PollingBGWrkrCancelReq = true;
                }
            }
        }

        private void EventTmr_Tick(object sender, EventArgs e)
        {
            string test;
            int i;

            test = "";

            for (i = 1; i < (NoArms + 3); i++)
            {
                test = test + SensorData[i].ToString();
            }
            LoadChart();
            
            textBox1.Text = test;
        }

        //------------------------------------------------
        //Load Graph
        //------------------------------------------------
        private void LoadChart()
        {
            int i, j;

            if (NewSnsrDataAvl == true)
            {
                DrawOrientation();

                //Odo Processing
                if (SensorData[NoArms + 2] > 0) OdoBox.Image = Properties.Resources.ON;
                else OdoBox.Image = Properties.Resources.OFF;
                SnsrPlot.ClearGraph();

                for (i = 0; i < NoArms; i++)
                {
                    SnsrPlot.AddElement();
                    SnsrPlot.ElementLineColor = Color.White;
                }
                SnsrPlot.SetRange(0, 200, 0.2, ((NoArms * 0.5) + 0.5));

                for (i = 0; i < 200; i++)
                {
                    for (j = 0; j < NoArms; j++)
                    {
                        if (CtMaxIndex > 199)
                        {
                            if (i < 199) GraphBufer[i, j] = GraphBufer[(i + 1), j];
                            else GraphBufer[i, j] = SensorData[j + 1];
                        }
                        else GraphBufer[CtMaxIndex, j] = SensorData[j + 1];
                        //Plot
                        if (i <= CtMaxIndex) SnsrPlot.PlotXY(i, (GraphBufer[i, j] + (j * 0.5)), (short)(j + 1));
                    }


                }

                if (CtMaxIndex < 200) CtMaxIndex++;
                NewSnsrDataAvl = false;
            }
        }

        //------------------------------------------------
        //Draw Orientation
        //------------------------------------------------
        private void DrawOrientation()
        {
            System.Drawing.RectangleF PictBoxRect = new RectangleF();
            System.Drawing.Pen NeedlePen = new System.Drawing.Pen(Color.Red);
            int[] NeedleCoOrds = new int[4];

            PictBoxRect.Size = OrntnBox.Size;
            PictBoxRect.Height = OrntnBox.Height - 1;
            PictBoxRect.Width = OrntnBox.Width - 1;
            PictBoxRect.X = 0;
            PictBoxRect.Y = 0;
            
            NeedlePen.Width = 2;

            Graphics g = OrntnBox.CreateGraphics();
            g.Clear(OrntnBox.BackColor);
            g.DrawEllipse(Pens.Black, PictBoxRect);

            NeedleCoOrds = GenerateOrntnDispParams(SensorData[NoArms + 1]);
            g.DrawLine(NeedlePen, NeedleCoOrds[0], NeedleCoOrds[1], NeedleCoOrds[2], NeedleCoOrds[3]);
            g.Dispose();

        }

        //---------------------------------------------------
        //Generate Orntn Parameters
        //---------------------------------------------------
        private int[] GenerateOrntnDispParams(double Orientation)
        {
            int[] OutVal = new int[4];
            double TmpDbl1, TmpDbl2;

            //''''''''''''''''''''''
            //'Populate Beginning X and Y
            //''''''''''''''''''''''
            OutVal[0] = (OrntnBox.Width - 1) / 2;
            OutVal[1] = (OrntnBox.Height - 1) / 2;

            //''''''''''''''''''''''
            //'Calculate End X and Y
            //''''''''''''''''''''''
            TmpDbl1 =  System.Math.Sin((Orientation * Math.PI) / 180) * ((OrntnBox.Width - 5) / 2);
            TmpDbl2 =  System.Math.Cos((Orientation * Math.PI) / 180) * ((OrntnBox.Height - 5) / 2);

            OutVal[2] = ((OrntnBox.Width - 5) / 2) - (int) TmpDbl1;
            OutVal[3] = ((OrntnBox.Height - 5) / 2) - (int) TmpDbl2;

            return OutVal;
        }

        //------------------------------------------------
        //Disable Init GUI and Show Data GUI
        //------------------------------------------------
        private void DisableInitGUI()
        {
            InitLoadPrgrsBar.Visible = false;

            BattGrpBox.Visible = true;
            ThrshldLbl.Visible = true;
            OdoBox.Visible = true;
            OrntnBox.Visible = true;
            SnsrPlot.Visible = true;
            CheckSnsrBtn.Visible = true;
            OdoLbl.Visible = true;
            BacktoMMBtn.Visible = true;

            if (Program.MainInst.AdminMode == 1)
            {
                NewThrshldTxtBox.Visible = true;
                LoadThrshld.Visible = true;
            }
            else
            {
                NewThrshldTxtBox.Visible = false;
                LoadThrshld.Visible = false;
            }
        }

        private void BacktoMMBtn_Click(object sender, EventArgs e)
        {
            if (InitLoadBgWrkr.IsBusy == true)
            {
                //Request Cancellation
                InitLoadBgWrkr.CancelAsync();
                InitBGWrkrCancelReq = true;
            }
            else if (PollingBGWrkr.IsBusy == true)
            {
                //Request Cancellation
                PollingBGWrkr.CancelAsync();
                PollingBGWrkrCancelReq = true;
                BackToMMReq = true;
            }
            else
            {
                Program.MainInst.Show();
                this.Dispose();
            }
        }

    }
}
