<?php
/**
 * Formatting information for different country phone number formatting.
 * Used when purchasing phone numbers. Number display should be returned 
 * correctly by Twilio when requesting IncomingNumbers from the API.
 *
 * by default the country code will be modified to support the numbers
 * buying interface, ie: US will show as "+1 ([area-code-input])". To handle
 * special cases add a second parameter that describes the search format, 
 * ie: 'US' => array('1', '+1 (*)'),
 */
$config['countrycodes'] = array(
	'AD' => array('376'), // Andorra 
	'AE' => array('971'), // United Arab Emirates 
	'AF' => array('93'), // Afghanistan 
	'AG' => array('1'), // Antigua and Barbuda 
	'AI' => array('1'), // Anguilla 
	'AL' => array('355'), // Albania 
	'AM' => array('374'), // Armenia 
	'AO' => array('244'), // Angola 
	'AQ' => array(''), // Antarctica 
	'AR' => array('54'), // Argentina 
	'AS' => array('1'), // American Samoa 
	'AT' => array('43'), // Austria 
	'AU' => array('61'), // Australia 
	'AW' => array('297'), // Aruba 
	'AX' => array('358'), // Åland Islands 
	'AZ' => array('994'), // Azerbaijan 
	'BA' => array('387'), // Bosnia and Herzegovina 
	'BB' => array('1'), // Barbados 
	'BD' => array('880'), // Bangladesh 
	'BE' => array('32'), // Belgium 
	'BF' => array('226'), // Burkina Faso 
	'BG' => array('359'), // Bulgaria 
	'BH' => array('973'), // Bahrain 
	'BI' => array('257'), // Burundi 
	'BJ' => array('229'), // Benin 
	'BL' => array('590'), // Saint Barthélemy 
	'BM' => array('1'), // Bermuda 
	'BN' => array('673'), // Brunei Darussalam 
	'BO' => array('591'), // Bolivia, Plurinational State of 
	'BQ' => array('599'), // Bonaire, Sint Eustatius and Saba 
	'BR' => array('55'), // Brazil 
	'BS' => array('1'), // Bahamas 
	'BT' => array('975'), // Bhutan 
	'BV' => array(''), // Bouvet Island 
	'BW' => array('267'), // Botswana 
	'BY' => array('375'), // Belarus 
	'BZ' => array('501'), // Belize 
	'CA' => array('1'), // Canada 
	'CC' => array('61'), // Cocos (Keeling) Islands 
	'CD' => array('243'), // Congo, the Democratic Republic of the 
	'CF' => array('236'), // Central African Republic 
	'CG' => array('242'), // Congo 
	'CH' => array('41'), // Switzerland 
	'CI' => array('225'), // Côte d'Ivoire 
	'CK' => array('682'), // Cook Islands 
	'CL' => array('56'), // Chile 
	'CM' => array('237'), // Cameroon 
	'CN' => array('86'), // China 
	'CO' => array('57'), // Colombia 
	'CR' => array('506'), // Costa Rica 
	'CU' => array('53'), // Cuba 
	'CV' => array('238'), // Cape Verde 
	'CW' => array('599'), // Curaçao 
	'CX' => array('61'), // Christmas Island 
	'CY' => array('357'), // Cyprus 
	'CZ' => array('420'), // Czech Republic 
	'DE' => array('49'), // Germany 
	'DJ' => array('253'), // Djibouti 
	'DK' => array('45'), // Denmark 
	'DM' => array('1'), // Dominica 
	'DO' => array('1'), // Dominican Republic 
	'DZ' => array('213'), // Algeria 
	'EC' => array('593'), // Ecuador 
	'EE' => array('372'), // Estonia 
	'EG' => array('20'), // Egypt 
	'EH' => array(''), // Western Sahara 
	'ER' => array('291'), // Eritrea 
	'ES' => array('34'), // Spain 
	'ET' => array('251'), // Ethiopia 
	'FI' => array('358'), // Finland 
	'FJ' => array('679'), // Fiji 
	'FK' => array('500'), // Falkland Islands (Malvinas) 
	'FM' => array('691'), // Micronesia, Federated States of 
	'FO' => array('298'), // Faroe Islands 
	'FR' => array('33'), // France 
	'GA' => array('241'), // Gabon 
	'GB' => array('44'), // United Kingdom 
	'GD' => array('1'), // Grenada 
	'GE' => array('241'), // Georgia 
	'GF' => array('594'), // French Guiana 
	'GG' => array('44'), // Guernsey 
	'GH' => array('233'), // Ghana 
	'GI' => array('350'), // Gibraltar 
	'GL' => array('299'), // Greenland 
	'GM' => array('220'), // Gambia 
	'GN' => array('224'), // Guinea 
	'GP' => array('590'), // Guadeloupe 
	'GQ' => array('240'), // Equatorial Guinea 
	'GR' => array('30'), // Greece 
	'GS' => array(''), // South Georgia and the South Sandwich Islands 
	'GT' => array('502'), // Guatemala 
	'GU' => array('1'), // Guam 
	'GW' => array('245'), // Guinea-Bissau 
	'GY' => array('592'), // Guyana 
	'HK' => array('852'), // Hong Kong 
	'HM' => array(''), // Heard Island and McDonald Islands 
	'HN' => array('504'), // Honduras 
	'HR' => array('385'), // Croatia 
	'HT' => array('509'), // Haiti 
	'HU' => array('36'), // Hungary 
	'ID' => array('62'), // Indonesia 
	'IE' => array('353'), // Ireland 
	'IL' => array('972'), // Israel 
	'IM' => array(''), // Isle of Man 
	'IN' => array('91'), // India 
	'IO' => array('246'), // British Indian Ocean Territory 
	'IQ' => array('694'), // Iraq 
	'IR' => array('98'), // Iran, Islamic Republic of 
	'IS' => array('354'), // Iceland 
	'IT' => array('39'), // Italy 
	'JE' => array('44'), // Jersey 
	'JM' => array('1'), // Jamaica 
	'JO' => array('962'), // Jordan 
	'JP' => array('81'), // Japan 
	'KE' => array('254'), // Kenya 
	'KG' => array('996'), // Kyrgyzstan 
	'KH' => array('855'), // Cambodia 
	'KI' => array('686'), // Kiribati 
	'KM' => array('269'), // Comoros 
	'KN' => array('1'), // Saint Kitts and Nevis 
	'KP' => array('850'), // Korea, Democratic People's Republic of 
	'KR' => array('82'), // Korea, Republic of 
	'KW' => array('965'), // Kuwait 
	'KY' => array('1'), // Cayman Islands 
	'KZ' => array('7'), // Kazakhstan 
	'LA' => array('856'), // Lao People's Democratic Republic 
	'LB' => array('961'), // Lebanon 
	'LC' => array('1'), // Saint Lucia 
	'LI' => array('243'), // Liechtenstein 
	'LK' => array('94'), // Sri Lanka 
	'LR' => array('231'), // Liberia 
	'LS' => array('266'), // Lesotho 
	'LT' => array('370'), // Lithuania 
	'LU' => array('352'), // Luxembourg 
	'LV' => array('371'), // Latvia 
	'LY' => array('218'), // Libyan Arab Jamahiriya 
	'MA' => array('212'), // Morocco 
	'MC' => array('377'), // Monaco 
	'MD' => array('373'), // Moldova, Republic of 
	'ME' => array('382'), // Montenegro 
	'MG' => array('261'), // Madagascar 
	'MF' => array('590'), // Saint Martin (French part) 
	'MH' => array('692'), // Marshall Islands 
	'MK' => array('389'), // Macedonia, the former Yugoslav Republic of 
	'ML' => array('223'), // Mali 
	'MM' => array('95'), // Myanmar 
	'MN' => array('976'), // Mongolia 
	'MO' => array('853'), // Macao 
	'MP' => array('1'), // Northern Mariana Islands 
	'MQ' => array('596'), // Martinique 
	'MR' => array('222'), // Mauritania 
	'MS' => array('1'), // Montserrat 
	'MT' => array('356'), // Malta 
	'MU' => array('230'), // Mauritius 
	'MV' => array('960'), // Maldives 
	'MW' => array('265'), // Malawi 
	'MX' => array('52'), // Mexico 
	'MY' => array('60'), // Malaysia 
	'MZ' => array('258'), // Mozambique 
	'NA' => array('264'), // Namibia 
	'NC' => array('687'), // New Caledonia 
	'NE' => array('227'), // Niger 
	'NF' => array('672'), // Norfolk Island 
	'NG' => array('234'), // Nigeria 
	'NI' => array('505'), // Nicaragua 
	'NL' => array('31'), // Netherlands 
	'NO' => array('47'), // Norway 
	'NP' => array('977'), // Nepal 
	'NR' => array('674'), // Nauru 
	'NU' => array('683'), // Niue 
	'NZ' => array('64'), // New Zealand 
	'OM' => array('968'), // Oman 
	'PA' => array('507'), // Panama 
	'PE' => array('51'), // Peru 
	'PF' => array('689'), // French Polynesia 
	'PG' => array('675'), // Papua New Guinea 
	'PH' => array('63'), // Philippines 
	'PK' => array('92'), // Pakistan 
	'PL' => array('48'), // Poland 
	'PM' => array('508'), // Saint Pierre and Miquelon 
	'PN' => array(''), // Pitcairn 
	'PR' => array('1'), // Puerto Rico 
	'PS' => array('970'), // Palestinian Territory, Occupied 
	'PT' => array('351'), // Portugal 
	'PW' => array('680'), // Palau 
	'PY' => array('595'), // Paraguay 
	'QA' => array('974'), // Qatar 
	'RE' => array('262'), // Réunion 
	'RO' => array('40'), // Romania 
	'RS' => array('381'), // Serbia 
	'RU' => array('7'), // Russian Federation 
	'RW' => array('250'), // Rwanda 
	'SA' => array('966'), // Saudi Arabia 
	'SB' => array('677'), // Solomon Islands 
	'SC' => array('248'), // Seychelles 
	'SD' => array('249'), // Sudan 
	'SE' => array('46'), // Sweden 
	'SG' => array('65'), // Singapore 
	'SH' => array('290'), // Saint Helena, Ascension and Tristan da Cunha 
	'SI' => array('386'), // Slovenia 
	'SJ' => array('47'), // Svalbard and Jan Mayen 
	'SK' => array('421'), // Slovakia 
	'SL' => array('232'), // Sierra Leone 
	'SM' => array('378'), // San Marino 
	'SN' => array('221'), // Senegal 
	'SO' => array('252'), // Somalia 
	'SR' => array('597'), // Suriname 
	'SS' => array('211'), // South Sudan 
	'ST' => array('239'), // Sao Tome and Principe 
	'SV' => array('503'), // El Salvador 
	'SX' => array('1'), // Sint Maarten (Dutch part) 
	'SY' => array('963'), // Syrian Arab Republic 
	'SZ' => array('268'), // Swaziland 
	'TC' => array('1'), // Turks and Caicos Islands 
	'TD' => array('235'), // Chad 
	'TF' => array(''), // French Southern Territories 
	'TG' => array('228'), // Togo 
	'TH' => array('66'), // Thailand 
	'TJ' => array('992'), // Tajikistan 
	'TK' => array('690'), // Tokelau 
	'TL' => array('670'), // Timor-Leste 
	'TM' => array('993'), // Turkmenistan 
	'TN' => array('216'), // Tunisia 
	'TO' => array('676'), // Tonga 
	'TR' => array('90'), // Turkey 
	'TT' => array('1'), // Trinidad and Tobago 
	'TV' => array('688'), // Tuvalu 
	'TW' => array('886'), // Taiwan, Province of China 
	'TZ' => array('255'), // Tanzania, United Republic of 
	'UA' => array('380'), // Ukraine 
	'UG' => array('256'), // Uganda 
	'UM' => array(''), // United States Minor Outlying Islands 
	'US' => array('1'), // United States 
	'UY' => array('598'), // Uruguay 
	'UZ' => array('998'), // Uzbekistan 
	'VA' => array('379'), // Holy See (Vatican City State) 
	'VC' => array('1'), // Saint Vincent and the Grenadines 
	'VE' => array('58'), // Venezuela, Bolivarian Republic of 
	'VG' => array('1'), // Virgin Islands, British 
	'VI' => array('1'), // Virgin Islands, U.S. 
	'VN' => array('84'), // Viet Nam 
	'VU' => array('678'), // Vanuatu 
	'WF' => array('681'), // Wallis and Futuna 
	'WS' => array('685'), // Samoa 
	'YE' => array('967'), // Yemen 
	'YT' => array(''), // Mayotte 
	'ZA' => array('27'), // South Africa 
	'ZM' => array('260'), // Zambia 
	'ZW' => array('263'), // Zimbabwe	
);