<?php
global $the_core_less_variables;
// initial default values
$the_core_less_variables['theme-color-1'] = '#d12a5c'; // main color, subtitles
$the_core_less_variables['theme-color-2'] = '#49ca9f'; // secondary color
$the_core_less_variables['theme-color-3'] = '#1f1f1f';
$the_core_less_variables['theme-color-4'] = '#808080';
$the_core_less_variables['theme-color-5'] = '#ebebeb';

// Background color for body
$the_core_less_variables['body-bg']        = '#ebebeb';
$the_core_less_variables['container-bg']   = '#ffffff'; // bg color when site style is Boxed
$the_core_less_variables['body-bg-image']  = 'data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==';
$the_core_less_variables['body-bg-repeat'] = 'no-repeat';

// Page Transition Spinner Color
$the_core_less_variables['fw-page-transition-spinner-color']  = $the_core_less_variables['theme-color-1'];

// Global text color on <body>
$the_core_less_variables['text-color'] = '#a8a8a8';

// Typography
// Font, line-height, and color for body text, headings, and more.
$the_core_less_variables['font-family-1']    = "'Montserrat'";
$the_core_less_variables['font-family-base'] = "'Quattrocento Sans', serif";

// Font Family Title, Subtitle, Buttons & Menu
$the_core_less_variables['font-weight-base']         = 'normal';
$the_core_less_variables['font-style-base']          = 'normal';
$the_core_less_variables['font-letter-spacing-base'] = '0';

$the_core_less_variables['subtitles-family']         = "'Merriweather'";
$the_core_less_variables['subtitles-weight']         = '300';
$the_core_less_variables['subtitles-style']          = 'normal';
$the_core_less_variables['subtitles-size']           = '22px';
$the_core_less_variables['subtitles-line-height']    = '39px';
$the_core_less_variables['subtitles-letter-spacing'] = 'normal';


$the_core_less_variables['fw-menu-font-family']    = $the_core_less_variables['font-family-1']; // from default value
$the_core_less_variables['fw-menu-font-weight']    = 'normal';
$the_core_less_variables['fw-menu-font-style']     = 'normal';
$the_core_less_variables['fw-menu-letter-spacing'] = '0';

$the_core_less_variables['fw-buttons-font-family']    = $the_core_less_variables['font-family-1']; // from default value
$the_core_less_variables['fw-buttons-font-weight']    = 'normal';
$the_core_less_variables['fw-buttons-font-style']     = 'normal';
$the_core_less_variables['fw-buttons-font-size']      = '12px';
$the_core_less_variables['fw-buttons-line-height']    = '30px';
$the_core_less_variables['fw-buttons-letter-spacing'] = 'normal';
$the_core_less_variables['fw-buttons-color']          = '#fff';
$the_core_less_variables['fw-buttons-hover-color']    = '#fff';


$the_core_less_variables['font-size-base'] = '16.5px';
// Letter Spacing Base
$the_core_less_variables['letter-spacing-base'] = 'normal';

// Typography
$the_core_less_variables['fw-h1-font-family'] = $the_core_less_variables['font-family-1']; // from default value
$the_core_less_variables['fw-h2-font-family'] = $the_core_less_variables['font-family-1'];
$the_core_less_variables['fw-h3-font-family'] = $the_core_less_variables['font-family-1'];
$the_core_less_variables['fw-h4-font-family'] = $the_core_less_variables['font-family-1'];
$the_core_less_variables['fw-h5-font-family'] = $the_core_less_variables['font-family-1'];
$the_core_less_variables['fw-h6-font-family'] = $the_core_less_variables['font-family-1'];

$the_core_less_variables['fw-h1-font-size'] = '55px';
$the_core_less_variables['fw-h2-font-size'] = '40px';
$the_core_less_variables['fw-h3-font-size'] = '32px';
$the_core_less_variables['fw-h4-font-size'] = '26px';
$the_core_less_variables['fw-h5-font-size'] = '19px';
$the_core_less_variables['fw-h6-font-size'] = '14px';

$the_core_less_variables['fw-h1-line-height'] = '65px';
$the_core_less_variables['fw-h2-line-height'] = '56px';
$the_core_less_variables['fw-h3-line-height'] = '38px';
$the_core_less_variables['fw-h4-line-height'] = '32px';
$the_core_less_variables['fw-h5-line-height'] = '28px';
$the_core_less_variables['fw-h6-line-height'] = '26px';

$the_core_less_variables['fw-h1-letter-spacing'] = '-2px';
$the_core_less_variables['fw-h2-letter-spacing'] = '-2px';
$the_core_less_variables['fw-h3-letter-spacing'] = '-2px';
$the_core_less_variables['fw-h4-letter-spacing'] = '-2px';
$the_core_less_variables['fw-h5-letter-spacing'] = '-1px';
$the_core_less_variables['fw-h6-letter-spacing'] = '-1px';

$the_core_less_variables['fw-h1-font-style'] = 'normal';
$the_core_less_variables['fw-h2-font-style'] = 'normal';
$the_core_less_variables['fw-h3-font-style'] = 'normal';
$the_core_less_variables['fw-h4-font-style'] = 'normal';
$the_core_less_variables['fw-h5-font-style'] = 'normal';
$the_core_less_variables['fw-h6-font-style'] = 'normal';

$the_core_less_variables['fw-h1-font-weight'] = 'normal';
$the_core_less_variables['fw-h2-font-weight'] = '700';
$the_core_less_variables['fw-h3-font-weight'] = '700';
$the_core_less_variables['fw-h4-font-weight'] = '700';
$the_core_less_variables['fw-h5-font-weight'] = '700';
$the_core_less_variables['fw-h6-font-weight'] = '700';

// Buttons
// Unit-less 'line-height' for use in components like buttons
$the_core_less_variables['line-height-small'] = '1.5em';
$the_core_less_variables['line-height-base']  = '1.7em';
$the_core_less_variables['line-height-large'] = '1.8em';

// here come from admin-styling, and for no conflict declare this here
$the_core_less_variables['fw-btn-color']       = $the_core_less_variables['theme-color-1'];
$the_core_less_variables['fw-btn-hover-color'] = $the_core_less_variables['theme-color-2'];

// Size theme (site full, site boxed, boxed)
$the_core_less_variables['fw-page-full']       = '100%';
$the_core_less_variables['fw-page-side-boxed'] = '1540px';

// Margin top & bottom for page
$the_core_less_variables['fw-site-margin-top']    = '0';
$the_core_less_variables['fw-site-margin-bottom'] = '0';

// Variable for space (padding or margin) in theme between element
$the_core_less_variables['fw-space-between-elements-sm'] = '45px';
$the_core_less_variables['fw-space-between-elements-md'] = '100px';
$the_core_less_variables['fw-space-between-elements-lg'] = '150px';

// Define common padding and border radius sizes and more. Values based on 14px text and 1.428 line-height (~20px to start).
$the_core_less_variables['padding-base-vertical']   = '12px';
$the_core_less_variables['padding-base-horizontal'] = '25px';

$the_core_less_variables['padding-large-vertical']   = '17px';
$the_core_less_variables['padding-large-horizontal'] = '45px';

$the_core_less_variables['padding-small-vertical']   = '6px';
$the_core_less_variables['padding-small-horizontal'] = '15px';

// Forms
// '<input>' background color
$the_core_less_variables['input-bg'] = '#fff';
// '<input disabled>' background color
$the_core_less_variables['input-bg-disabled'] = '#f2f2f2';
// '<input>' border color
$the_core_less_variables['input-border'] = '#ccc';
// '<input>' border radius
$the_core_less_variables['input-border-radius'] = '0';

// default value, is used in other variables
$the_core_less_variables['font-family-2'] = $the_core_less_variables['font-family-base'];

// Fonts variables for all inputs form themes
$the_core_less_variables['input-font-family']    = $the_core_less_variables['font-family-2']; // is rewrite from admin-styling
$the_core_less_variables['input-font-style']     = 'normal';
$the_core_less_variables['input-font-size']      = '16.5px';
$the_core_less_variables['input-line-height']    = '28px';
$the_core_less_variables['input-font-weight']    = '700';
$the_core_less_variables['input-letter-spacing'] = '0';
$the_core_less_variables['input-color']          = $the_core_less_variables['theme-color-3']; // is rewrite from admin-styling

// Horizontal and vertical padding
$the_core_less_variables['input-padding-x'] = '15px';
$the_core_less_variables['input-padding-y'] = '12px';

// Default '.form-control' height
$the_core_less_variables['input-height-base'] = ( $the_core_less_variables['input-padding-x'] * 2 ) . 'px'; // from default value

// Fonts variables for all labels form themes
$the_core_less_variables['form-label-font-family']    = $the_core_less_variables['font-family-1']; // from default value
$the_core_less_variables['form-label-font-size']      = '12px';
$the_core_less_variables['form-label-font-style']     = 'normal';
$the_core_less_variables['form-label-font-weight']    = '400';
$the_core_less_variables['form-label-line-height']    = '30px';
$the_core_less_variables['form-label-letter-spacing'] = '0';
$the_core_less_variables['form-label-color']          = '#b2b2b2';
$the_core_less_variables['form-label-text-transform'] = 'uppercase';

// Panel icon size
$the_core_less_variables['panel-icon-size'] = '17px';

// Mobile menu
$the_core_less_variables['fw-icon-font-size-mobile-menu']   = '28px';
$the_core_less_variables['fw-icon-line-height-mobile-menu'] = ( $the_core_less_variables['fw-icon-font-size-mobile-menu'] - 7 ) . 'px'; // from default value

// Menu item hover color (header & footer menu)
$the_core_less_variables['fw-top-menu-item-color-hover']    = $the_core_less_variables['theme-color-2']; // rewrite in admin-styling
$the_core_less_variables['fw-footer-menu-item-color-hover'] = $the_core_less_variables['theme-color-1']; // rewrite in admin-styling

// Header Layout
$the_core_less_variables['fw-top-bar-bg']                = 'transparent';
$the_core_less_variables['fw-top-bar-bg-absolute']       = 'transparent';
$the_core_less_variables['fw-top-bar-padding']           = '10px';
$the_core_less_variables['fw-top-bar-height']            = '35px'; // height for content inside it
$the_core_less_variables['fw-top-bar-text-color']        = '#ffffff';
$the_core_less_variables['fw-header-social-color']       = '#ffffff';
$the_core_less_variables['fw-header-social-hover-color'] = '#cfebde';
$the_core_less_variables['fw-top-bar-font-size-text']    = '16px';
$the_core_less_variables['fw-top-bar-font-style']        = 'normal';
$the_core_less_variables['fw-top-bar-font-weight']       = 'normal';
$the_core_less_variables['fw-top-bar-font-family']       = "'NTR'";
$the_core_less_variables['fw-top-bar-letter-spacing']    = '0.3px';
$the_core_less_variables['fw-top-bar-font-size-social']  = '16px';

// spacing between elements: sections, shortcodes and others
$the_core_less_variables['fw-content-density-sm'] = '5px';
$the_core_less_variables['fw-content-density-md'] = '10px'; // default value
$the_core_less_variables['fw-content-density-lg'] = '15px';
$the_core_less_variables['fw-content-density']    = $the_core_less_variables['fw-content-density-md']; // from default value

$the_core_less_variables['fw-top-menu-bg']                 = 'transparent';
$the_core_less_variables['fw-header-padding-top']          = ( $the_core_less_variables['fw-content-density'] * 4 ) . 'px';
$the_core_less_variables['fw-header-padding-bot']          = ( $the_core_less_variables['fw-content-density'] * 4 ) . 'px';
$the_core_less_variables['fw-logo-wrap-height']            = '160px';
$the_core_less_variables['fw-header-absolute-opacity']     = '90%';
$the_core_less_variables['fw-header-2-padding-logo']       = '50px'; // logo's margin left & right
$the_core_less_variables['fw-header-boxed-position-top']   = '0'; // position menu if option "Boxed Header" is YES
$the_core_less_variables['fw-logo-wrap-height-absolute']   = '60px';
$the_core_less_variables['fw-header-padding-top-absolute'] = $the_core_less_variables['fw-content-density'] . 'px'; // from default value
$the_core_less_variables['fw-header-padding-bot-absolute'] = $the_core_less_variables['fw-content-density'] . 'px'; // from default value

// Top menu
$the_core_less_variables['fw-menu-item-font-size']       = '13px';
$the_core_less_variables['fw-menu-item-margin-left']     = '40px';
$the_core_less_variables['fw-menu-item-height']          = '30px';
$the_core_less_variables['fw-top-menu-color']            = $the_core_less_variables['theme-color-3'];
$the_core_less_variables['fw-menu-wrap-bg']              = 'transparent';
$the_core_less_variables['fw-dropdown-width']            = '280px';
$the_core_less_variables['fw-dropdown-bg-color']         = $the_core_less_variables['theme-color-3']; // rewrite in admin-styling
$the_core_less_variables['fw-dropdown-text-color']       = $the_core_less_variables['theme-color-2']; // rewrite in admin-styling
$the_core_less_variables['fw-dropdown-text-color-hover'] = '#fff';
$the_core_less_variables['fw-dropdown-icon-size']        = '14px';
$the_core_less_variables['fw-menu-logo-max-width']       = '250px';
$the_core_less_variables['fw-menu-logo-width']           = '400px';
$the_core_less_variables['fw-menu-logo-height']          = (floatval($the_core_less_variables['fw-menu-logo-width']) / 2).'px';

// Header type 5 variables
$the_core_less_variables['fw-header-5-bg-color']               = '#fff';
$the_core_less_variables['fw-header-5-bg-image']               = 'data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==';
$the_core_less_variables['fw-header-5-bg-repeat']              = 'no-repeat';
$the_core_less_variables['fw-header-5-bg-horizontal-position'] = 'center';
$the_core_less_variables['fw-header-5-bg-vertical-position']   = 'center';
$the_core_less_variables['fw-header-5-bg-size']                = 'cover';
$the_core_less_variables['fw-header-5-overlay-color']          = 'transparent';
$the_core_less_variables['fw-header-5-overlay-transparent']    = '0';
$the_core_less_variables['fw-header-5-menu-icon-size']         = '25px';
$the_core_less_variables['fw-header-5-menu-icon-color']        = $the_core_less_variables['theme-color-1']; // rewrite in admin-styling
$the_core_less_variables['fw-header-5-menu-icon-color-hover']  = $the_core_less_variables['theme-color-2']; // rewrite in admin-styling

// Header type 6 variables
$the_core_less_variables['fw-header-6-bg-color']                = '#fff';
$the_core_less_variables['fw-header-6-bg-image']                = 'data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==';
$the_core_less_variables['fw-header-6-bg-repeat']               = 'no-repeat';
$the_core_less_variables['fw-header-6-bg-horizontal-position']  = 'center';
$the_core_less_variables['fw-header-6-bg-vertical-position']    = 'center';
$the_core_less_variables['fw-header-6-bg-size']                 = 'cover';
$the_core_less_variables['fw-header-6-overlay-color']           = 'transparent';
$the_core_less_variables['fw-header-6-overlay-transparent']     = '0';
$the_core_less_variables['fw-header-6-menu-social-color']       = $the_core_less_variables['theme-color-1']; // rewrite in admin-styling
$the_core_less_variables['fw-header-6-menu-social-color-hover'] = $the_core_less_variables['theme-color-2']; // rewrite in admin-styling
$the_core_less_variables['fw-header-6-menu-social-size']        = '16px';

// Bottom menu
$the_core_less_variables['fw-bottom-menu-font-family']    = $the_core_less_variables['fw-menu-font-family']; // rewrite in admin-styling
$the_core_less_variables['fw-bottom-menu-font-weight']    = $the_core_less_variables['fw-menu-font-weight'];
$the_core_less_variables['fw-bottom-menu-font-style']     = $the_core_less_variables['fw-menu-font-style'];
$the_core_less_variables['fw-bottom-menu-letter-spacing'] = '1px';
$the_core_less_variables['fw-bottom-menu-font-size']      = '13px';
$the_core_less_variables['fw-bottom-menu-item-margin']    = '35px';
$the_core_less_variables['fw-bottom-menu-item-height']    = '84px';

// Text logo
$the_core_less_variables['fw-logo-title-font-family']    = $the_core_less_variables['font-family-1']; // from default value
$the_core_less_variables['fw-logo-title-font-weight']    = 'normal';
$the_core_less_variables['fw-logo-title-font-style']     = 'normal';
$the_core_less_variables['fw-logo-title-font-size']      = '20px';
$the_core_less_variables['fw-logo-title-letter-spacing'] = '1px';
$the_core_less_variables['fw-logo-title-line-height']    = '20px';
$the_core_less_variables['fw-logo-title-color']          = $the_core_less_variables['theme-color-2']; // rewrite in admin-styling

$the_core_less_variables['fw-logo-subtitle-font-family']    = $the_core_less_variables['font-family-2']; // rewrite in admin-styling
$the_core_less_variables['fw-logo-subtitle-font-weight']    = 'normal';
$the_core_less_variables['fw-logo-subtitle-font-style']     = 'normal';
$the_core_less_variables['fw-logo-subtitle-font-size']      = '10px';
$the_core_less_variables['fw-logo-subtitle-letter-spacing'] = '4px';
$the_core_less_variables['fw-logo-subtitle-line-height']    = '10px';
$the_core_less_variables['fw-logo-subtitle-color']          = '#aeaab1';

$the_core_less_variables['fw-header-search-input-bg-color']       = 'transparent';
$the_core_less_variables['fw-header-search-input-icon-color']     = $the_core_less_variables['theme-color-2']; // rewrite in admin-styling
$the_core_less_variables['fw-header-search-input-icon-bg-color']  = 'transparent';
$the_core_less_variables['fw-header-search-input-icon-font-size'] = '16px';
$the_core_less_variables['fw-header-search-mini-width']           = '257px';
$the_core_less_variables['fw-header-search-width']                = '204px';
$the_core_less_variables['fw-header-search-mini-padding']         = '15px';

$the_core_less_variables['fw-header-search-input-color']        = '#fff';
$the_core_less_variables['fw-form-search-full-font-color']      = $the_core_less_variables['fw-header-search-input-color']; // rewrite from admin-styling
$the_core_less_variables['fw-form-search-full-bg']              = $the_core_less_variables['fw-form-search-full-font-color']; // rewrite from admin-styling
$the_core_less_variables['fw-form-search-full-input-font-size'] = '40px';

$the_core_less_variables['fw-header-search-input-font-family']    = $the_core_less_variables['font-family-2']; // from default value
$the_core_less_variables['fw-header-search-input-font-weight']    = 'normal';
$the_core_less_variables['fw-header-search-input-font-style']     = 'normal';
$the_core_less_variables['fw-header-search-input-font-size']      = '14px';
$the_core_less_variables['fw-header-search-input-letter-spacing'] = 'normal';
$the_core_less_variables['fw-header-search-input-height']         = '33px';
$the_core_less_variables['fw-header-search-input-border-size']    = '0px';
$the_core_less_variables['fw-header-search-input-border-color']   = 'transparent';

// Section Overlay
$the_core_less_variables['fw-content-overlay-sm'] = '40px';
$the_core_less_variables['fw-content-overlay-md'] = '80px';
$the_core_less_variables['fw-content-overlay-lg'] = '120px';

// Section Height
$the_core_less_variables['fw-section-height-sm'] = '240px';
$the_core_less_variables['fw-section-height-md'] = '300px';
$the_core_less_variables['fw-section-height-lg'] = '440px';

// Footer Layout
// Widget area styles
$the_core_less_variables['fw-footer-widgets-bg']         = '#d1d3d5'; // footer section's bg color
$the_core_less_variables['fw-footer-widget-bg-image']    = 'data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw=='; // section's bg image
$the_core_less_variables['fw-footer-widget-bg-repeat']   = 'no-repeat'; // section's bg repeat
$the_core_less_variables['fw-footer-widget-bg-position'] = 'top right'; // section's bg position
$the_core_less_variables['fw-footer-widget-bg-size']     = 'auto'; // section's bg size
$the_core_less_variables['fw-footer-widgets-text-color'] = $the_core_less_variables['theme-color-3']; // text color for widgets // rewrite in admin-styling
$the_core_less_variables['fw-footer-widgets-title']      = '#fff'; // text color for Widgets Titles
$the_core_less_variables['fw-footer-widgets-title-size'] = '23px';
$the_core_less_variables['fw-footer-widgets-padding']    = ( floatval( $the_core_less_variables['fw-content-density'] ) * 14 ) . 'px'; // top & bottom padding of widget container // from default value

// Footer menu with logo styles
$the_core_less_variables['fw-footer-middle-bg']           = 'transparent';
$the_core_less_variables['fw-menu-bar-bg-image']          = 'data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw=='; // menu bar bg
$the_core_less_variables['fw-menu-bar-bg-repeat']         = 'no-repeat'; // menu bar bg repeat
$the_core_less_variables['fw-menu-bar-bg-position']       = 'top right'; // menu bar bg position
$the_core_less_variables['fw-menu-current-line-height']   = '6px';
$the_core_less_variables['fw-footer-middle-bg-size']      = 'auto'; // menu bar bg size
$the_core_less_variables['fw-footer-middle-text']         = '#fff'; // menu color
$the_core_less_variables['fw-footer-middle-padding-top']  = '18px';
$the_core_less_variables['fw-footer-middle-padding-bot']  = '18px';
$the_core_less_variables['fw-footer-widgets-padding-top'] = $the_core_less_variables['fw-space-between-elements-md']; // from default value
$the_core_less_variables['fw-footer-widgets-padding-bot'] = $the_core_less_variables['fw-space-between-elements-md']; // from default value

// copyright with socials
$the_core_less_variables['fw-footer-bar-bg']             = 'transparent';
$the_core_less_variables['fw-footer-social-color']       = $the_core_less_variables['theme-color-3']; // rewrite from admin-styling
$the_core_less_variables['fw-footer-social-hover-color'] = $the_core_less_variables['theme-color-1']; // rewrite from admin-styling
$the_core_less_variables['fw-footer-bar-padding-top']    = '20px';
$the_core_less_variables['fw-footer-bar-padding-bot']    = $the_core_less_variables['fw-footer-bar-padding-top']; // rewrite from admin-styling
$the_core_less_variables['fw-footer-bar-link']           = '#fff';
$the_core_less_variables['fw-footer-bar-link-hover']     = '#fff';

$the_core_less_variables['fw-footer-social-size']       = '16px'; // footer social icons size
$the_core_less_variables['fw-copyright-font-size']      = '15px'; // font size of copyright text
$the_core_less_variables['fw-copyright-font-style']     = 'normal';
$the_core_less_variables['fw-copyright-font-weight']    = 'normal';
$the_core_less_variables['fw-copyright-font-family']    = $the_core_less_variables['font-family-base']; // rewrite from admin-styling
$the_core_less_variables['fw-copyright-text-color']     = '#686869';
$the_core_less_variables['fw-copyright-letter-spacing'] = 'normal';
$the_core_less_variables['fw-copyright-line-height']    = '45px';

// Footer Logo
$the_core_less_variables['fw-footer-logo-width']      = '100px';
$the_core_less_variables['fw-footer-logo-height']     = '65px';
$the_core_less_variables['fw-footer-logo-max-height'] = '100px';

// Sections padding
// Padding top & bottom in all sections
$the_core_less_variables['fw-section-padding'] = $the_core_less_variables['fw-space-between-elements-md']; // from default value

$the_core_less_variables['fw-section-padding-sm'] = $the_core_less_variables['fw-section-padding'] * 0.6 . 'px'; // from default value
$the_core_less_variables['fw-section-padding-md'] = $the_core_less_variables['fw-section-padding']; // from default value
$the_core_less_variables['fw-section-padding-lg'] = $the_core_less_variables['fw-section-padding'] * 1.4 . 'px'; // from default value

// Core Shortcodes
// buttons font-family & font-weight
$the_core_less_variables['fw-btn-font-family']    = $the_core_less_variables['fw-buttons-font-family']; // rewrite from admin-styling
$the_core_less_variables['fw-btn-font-weight']    = $the_core_less_variables['fw-buttons-font-weight']; // rewrite from admin-styling
$the_core_less_variables['fw-btn-font-style']     = $the_core_less_variables['fw-buttons-font-style']; // rewrite from admin-styling
$the_core_less_variables['fw-btn-font-size']      = $the_core_less_variables['fw-buttons-font-size']; // rewrite from admin-styling
$the_core_less_variables['fw-btn-line-height']    = $the_core_less_variables['fw-buttons-line-height']; // rewrite from admin-styling
$the_core_less_variables['fw-btn-letter-spacing'] = $the_core_less_variables['fw-buttons-letter-spacing']; // rewrite from admin-styling

// button 1
$the_core_less_variables['fw-btn-border-color'] = 'transparent';
$the_core_less_variables['fw-btn-border-width'] = 0;
$the_core_less_variables['fw-btn-radius']       = 0;
$the_core_less_variables['fw-btn-shadow']       = 'none';
$the_core_less_variables['fw-btn-shadow-inset'] = 'none';
$the_core_less_variables['fw-btn-text-shadow']  = 'none';

// button 2
$the_core_less_variables['fw-btn-border-width2'] = '2px';
$the_core_less_variables['fw-btn-radius2']       = '0';
$the_core_less_variables['fw-btn-shadow2']       = 'none';
$the_core_less_variables['fw-btn-shadow-inset2'] = 'none';
$the_core_less_variables['fw-btn-text-shadow2']  = 'none';

// button 3
$the_core_less_variables['fw-btn-border-width3'] = '2px';
$the_core_less_variables['fw-btn-radius3']       = '0';
$the_core_less_variables['fw-btn-shadow-inset3'] = 'none';
$the_core_less_variables['fw-btn-text-shadow3']  = 'none';

// Dividers
$the_core_less_variables['fw-divider-space-sm'] = '30px'; // height of small divider
$the_core_less_variables['fw-divider-space-md'] = '60px'; // height of medium divider
$the_core_less_variables['fw-divider-space-lg'] = '100px'; // height of large divider

// Single Image & Image Block
$the_core_less_variables['fw-block-image-frame-color'] = '#edf1f2';
$the_core_less_variables['fw-block-image-frame-size']  = '9px';

// Post List Grid View
$the_core_less_variables['fw-postlist-grid-content-bg']      = 'transparent';
$the_core_less_variables['fw-postlist-grid-content-padding'] = '40px';

// Blog Meta
$the_core_less_variables['fw-blog-meta-font-family']    = $the_core_less_variables['fw-h2-font-family']; // rewrite from admin-styling
$the_core_less_variables['fw-blog-meta-font-style']     = $the_core_less_variables['fw-h2-font-style']; // rewrite from admin-styling
$the_core_less_variables['fw-blog-meta-font-weight']    = $the_core_less_variables['fw-h2-font-weight']; // rewrite from admin-styling
$the_core_less_variables['fw-blog-meta-font-size']      = $the_core_less_variables['font-size-base']; // rewrite from admin-styling
$the_core_less_variables['fw-blog-meta-line-height']    = $the_core_less_variables['line-height-base']; // rewrite from admin-styling
$the_core_less_variables['fw-blog-meta-letter-spacing'] = $the_core_less_variables['letter-spacing-base']; // rewrite from admin-styling
$the_core_less_variables['fw-blog-meta-color']          = $the_core_less_variables['theme-color-2']; // $the_core_less_variables['link-color']; // rewrite from admin-styling
$the_core_less_variables['fw-blog-meta-color-hover']    = the_core_adjustColorLightenDarken( $the_core_less_variables['theme-color-2'], 10 ); // $the_core_less_variables['link-hover-color']; // rewrite from admin-styling
$the_core_less_variables['fw-blog-meta-lettercase']     = 'none'; // rewrite from admin-styling

// Sidebar Widgets
// Widget Title
$the_core_less_variables['fw-widget-title-font-size']   = '15px';
$the_core_less_variables['fw-widget-title-line-height'] = '40px';
$the_core_less_variables['fw-widget-title-color']       = '#b6b8b9';
$the_core_less_variables['fw-widget-line-height']       = '55px';

// Widget Inner Title
$the_core_less_variables['fw-widget-inner-title-font-family']    = $the_core_less_variables['font-family-2']; // rewrite from admin-styling
$the_core_less_variables['fw-widget-inner-title-font-size']      = '15px';
$the_core_less_variables['fw-widget-inner-title-font-style']     = 'normal';
$the_core_less_variables['fw-widget-inner-title-font-weight']    = '700';
$the_core_less_variables['fw-widget-inner-title-line-height']    = '26px';
$the_core_less_variables['fw-widget-inner-title-letter-spacing'] = '1px';
$the_core_less_variables['fw-widget-inner-title-color']          = '#353535';
$the_core_less_variables['fw-widget-inner-title-hover-color']    = $the_core_less_variables['theme-color-1']; // rewrite from admin-styling
$the_core_less_variables['fw-widget-input-bg']                   = '#000';


// from this line are styles with multiple rewriting, because are from a variable that come from dashboard, but have and a value from theme settings
// search placeholder
$the_core_less_variables['fw-form-search-full-placeholder-font-color'] = $the_core_less_variables['fw-form-search-full-font-color'];

// Global textual link color
$the_core_less_variables['link-color'] = $the_core_less_variables['theme-color-2']; // rewrite from admin-styling
// Link hover color set via darken() function
$the_core_less_variables['link-hover-color'] = the_core_adjustColorLightenDarken( $the_core_less_variables['theme-color-2'], 10 ); // rewrite from admin-styling

// heading colors
$the_core_less_variables['fw-h1-color'] = $the_core_less_variables['theme-color-3']; // rewrite from admin-styling
$the_core_less_variables['fw-h2-color'] = $the_core_less_variables['theme-color-3']; // rewrite from admin-styling
$the_core_less_variables['fw-h3-color'] = $the_core_less_variables['theme-color-3']; // rewrite from admin-styling
$the_core_less_variables['fw-h4-color'] = $the_core_less_variables['theme-color-3']; // rewrite from admin-styling
$the_core_less_variables['fw-h5-color'] = $the_core_less_variables['theme-color-3']; // rewrite from admin-styling
$the_core_less_variables['fw-h6-color'] = $the_core_less_variables['theme-color-3']; // rewrite from admin-styling

$the_core_less_variables['subtitles-color'] = $the_core_less_variables['text-color'];

$the_core_less_variables['fw-top-menu-line-color'] = $the_core_less_variables['fw-top-menu-color'];

// Scroll To Top Button
$the_core_less_variables['fw-scroll-to-top-color'] = $the_core_less_variables['theme-color-1'];


// rewrite the global variable : $the_core_less_variables (for rewrite the value that are changed from dashboard)
the_core_render_view( get_template_directory() . '/dynamic-css/fw-admin-styling.php', array(), false );
// after fw-admin-styling will be all variables that are dependent of dashboard options


// font family
$the_core_less_variables['font-family-2']   = $the_core_less_variables['font-family-base'];

// font size base
$the_core_less_variables['font-size-large'] = ceil( $the_core_less_variables['font-size-base'] * 1.15 ) . 'px';
$the_core_less_variables['font-size-small'] = ceil( $the_core_less_variables['font-size-base'] * 0.85 ) . 'px';

// Computed 'line-height' ('font-size' * 'line-height') for use with 'margin', 'padding', etc
$the_core_less_variables['line-height-computed'] = $the_core_less_variables['font-size-base'];

// Border color for inputs on focus
$the_core_less_variables['input-border-focus'] = the_core_adjustColorLightenDarken( $the_core_less_variables['theme-color-2'], 30 );

// Placeholder text color
$the_core_less_variables['input-color-placeholder'] = the_core_hex2rgba( $the_core_less_variables['theme-color-2'], 0.7 );

// Header
$the_core_less_variables['fw-header-info-text-color']    = $the_core_less_variables['text-color'];
$the_core_less_variables['fw-dropdown-font-size']        = $the_core_less_variables['fw-menu-item-font-size'];
$the_core_less_variables['fw-dropdown-font-family']      = $the_core_less_variables['fw-menu-font-family'];
$the_core_less_variables['fw-dropdown-letter-spacing']      = $the_core_less_variables['fw-menu-letter-spacing'];
$the_core_less_variables['fw-dropdown-bg-color-hover']   = the_core_hex2rgba( the_core_adjustColorLightenDarken( $the_core_less_variables['fw-dropdown-bg-color'], 30 ), 0.94 );
$the_core_less_variables['fw-header-5-menu-icon-height'] = ( floatval( $the_core_less_variables['fw-header-5-menu-icon-size'] ) - 6 ) . 'px';

// Search form
$the_core_less_variables['fw-header-search-input-icon-color-hover'] = the_core_adjustColorLightenDarken( $the_core_less_variables['fw-header-search-input-icon-color'], - 10 );
$the_core_less_variables['fw-header-search-mini-bg']                = the_core_adjustColorLightenDarken( $the_core_less_variables['fw-header-search-input-bg-color'], 10 );

$the_core_less_variables['fw-form-search-full-loop-color']             = $the_core_less_variables['fw-form-search-full-font-color'];
$the_core_less_variables['fw-form-search-full-close-color']            = $the_core_less_variables['fw-form-search-full-font-color'];
$the_core_less_variables['fw-form-search-full-input-bg']               = $the_core_less_variables['fw-header-search-input-bg-color'];

$the_core_less_variables['fw-footer-widgets-link-color'] = $the_core_less_variables['fw-footer-widgets-text-color'];
$the_core_less_variables['fw-footer-middle-text-hover']  = $the_core_less_variables['theme-color-2']; // menu color on hover
$the_core_less_variables['fw-footer-bar-text']           = $the_core_less_variables['fw-footer-social-color'];

$the_core_less_variables['fw-btn-text-color']       = $the_core_less_variables['fw-buttons-color'];
$the_core_less_variables['fw-btn-text-color-hover'] = $the_core_less_variables['fw-buttons-hover-color'];
$the_core_less_variables['fw-btn-bg-color']         = $the_core_less_variables['fw-btn-color']; // main btn color
$the_core_less_variables['fw-btn-bg-color-hover']   = $the_core_less_variables['fw-btn-hover-color']; // main btn color on hover

// Button 2
$the_core_less_variables['fw-btn-bg-color2']         = $the_core_less_variables['fw-btn-color']; // main btn color
$the_core_less_variables['fw-btn-border-color2']     = $the_core_less_variables['fw-btn-bg-color2'];
$the_core_less_variables['fw-btn-text-color2']       = $the_core_less_variables['fw-buttons-color'];
$the_core_less_variables['fw-btn-text-color-hover2'] = $the_core_less_variables['fw-buttons-hover-color'];
$the_core_less_variables['fw-btn-bg-color-hover2']   = $the_core_less_variables['fw-btn-hover-color']; // main btn color on hover

// Button 3
$the_core_less_variables['fw-btn-text-color3']       = $the_core_less_variables['fw-buttons-color'];
$the_core_less_variables['fw-btn-border-color3']     = $the_core_less_variables['fw-btn-text-color3'];
$the_core_less_variables['fw-btn-shadow3']           = the_core_adjustColorLightenDarken( $the_core_less_variables['fw-btn-text-color3'], 10 );
$the_core_less_variables['fw-btn-text-color-hover3'] = $the_core_less_variables['fw-buttons-hover-color'];
$the_core_less_variables['fw-btn-bg-color3']         = $the_core_less_variables['fw-btn-color']; // use for solid color
$the_core_less_variables['fw-btn-bg-color-hover3']   = $the_core_less_variables['fw-btn-hover-color']; // use for solid color

// Button 4
$the_core_less_variables['fw-btn-text-color4']       = $the_core_less_variables['fw-buttons-color'];
$the_core_less_variables['fw-btn-text-color-hover4'] = $the_core_less_variables['fw-buttons-hover-color'];

// Widget
$the_core_less_variables['fw-widget-font-size']   = ( (int) $the_core_less_variables['font-size-base'] - 1 ) . 'px';
$the_core_less_variables['fw-widget-line-height'] = ( (int) $the_core_less_variables['line-height-base'] - 2 ) . 'px';
?>